/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.posix;

import java.sql.Date;
import java.sql.Time;
import java.util.EnumSet;
import java.util.Formatter;
import org.dcache.chimera.UnixPermission;

public class Stat {
    private final EnumSet<StatAttributes> _definedAttrs = EnumSet.noneOf(StatAttributes.class);
    private int _dev;
    private int _ino;
    private int _mode;
    private int _nlink;
    private int _uid;
    private int _gid;
    private int _rdev;
    private long _size;
    private long _generation;
    private long _atime;
    private long _mtime;
    private long _ctime;
    private long _crtime;

    public int getDev() {
        this.guard(StatAttributes.DEV);
        return this._dev;
    }

    public void setDev(int dev) {
        this.define(StatAttributes.DEV);
        this._dev = dev;
    }

    public int getIno() {
        this.guard(StatAttributes.INO);
        return this._ino;
    }

    public void setIno(int ino) {
        this.define(StatAttributes.INO);
        this._ino = ino;
    }

    public int getMode() {
        this.guard(StatAttributes.MODE);
        return this._mode;
    }

    public void setMode(int mode) {
        this.define(StatAttributes.MODE);
        this._mode = mode;
    }

    public int getNlink() {
        this.guard(StatAttributes.NLINK);
        return this._nlink;
    }

    public void setNlink(int nlink) {
        this.define(StatAttributes.NLINK);
        this._nlink = nlink;
    }

    public int getUid() {
        this.guard(StatAttributes.UID);
        return this._uid;
    }

    public void setUid(int uid) {
        this.define(StatAttributes.UID);
        this._uid = uid;
    }

    public int getGid() {
        this.guard(StatAttributes.GID);
        return this._gid;
    }

    public void setGid(int gid) {
        this.define(StatAttributes.GID);
        this._gid = gid;
    }

    public int getRdev() {
        this.guard(StatAttributes.RDEV);
        return this._rdev;
    }

    public void setRdev(int rdev) {
        this.define(StatAttributes.RDEV);
        this._rdev = rdev;
    }

    public long getSize() {
        this.guard(StatAttributes.SIZE);
        return this._size;
    }

    public void setSize(long size) {
        this.define(StatAttributes.SIZE);
        this._size = size;
    }

    public long getATime() {
        this.guard(StatAttributes.ATIME);
        return this._atime;
    }

    public void setATime(long atime) {
        this.define(StatAttributes.ATIME);
        this._atime = atime;
    }

    public long getMTime() {
        this.guard(StatAttributes.MTIME);
        return this._mtime;
    }

    public void setMTime(long mtime) {
        this.define(StatAttributes.MTIME);
        this._mtime = mtime;
    }

    public long getCTime() {
        this.guard(StatAttributes.CTIME);
        return this._ctime;
    }

    public void setCTime(long ctime) {
        this.define(StatAttributes.CTIME);
        this._ctime = ctime;
    }

    public long getGeneration() {
        this.guard(StatAttributes.GENERATION);
        return this._generation;
    }

    public void setGeneration(long generation) {
        this.define(StatAttributes.GENERATION);
        this._generation = generation;
    }

    public void setCrTime(long newCrTime) {
        this.define(StatAttributes.CRTIME);
        this._crtime = newCrTime;
    }

    public long getCrTime() {
        this.guard(StatAttributes.CRTIME);
        return this._crtime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        try (Formatter formatter = new Formatter(sb);){
            formatter.format("%s %8d %6d %6d %6d %6d %s %s", new UnixPermission(this.getMode()), this.getNlink(), this.getUid(), this.getGid(), this.getSize(), this.getGeneration(), new Date(this.getMTime()), new Time(this.getMTime()));
            formatter.flush();
        }
        return sb.toString();
    }

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + this._dev;
        hash = 79 * hash + this._ino;
        hash = 79 * hash + this._mode;
        hash = 79 * hash + this._nlink;
        hash = 79 * hash + this._uid;
        hash = 79 * hash + this._gid;
        hash = 79 * hash + this._rdev;
        hash = 79 * hash + (int)(this._size ^ this._size >>> 32);
        hash = 79 * hash + (int)(this._atime ^ this._atime >>> 32);
        hash = 79 * hash + (int)(this._mtime ^ this._mtime >>> 32);
        hash = 79 * hash + (int)(this._ctime ^ this._ctime >>> 32);
        hash = 79 * hash + (int)(this._crtime ^ this._crtime >>> 32);
        hash = 79 * hash + (int)(this._generation ^ this._generation >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Stat other = (Stat)obj;
        if (this._dev != other._dev) {
            return false;
        }
        if (this._ino != other._ino) {
            return false;
        }
        if (this._mode != other._mode) {
            return false;
        }
        if (this._nlink != other._nlink) {
            return false;
        }
        if (this._uid != other._uid) {
            return false;
        }
        if (this._gid != other._gid) {
            return false;
        }
        if (this._rdev != other._rdev) {
            return false;
        }
        if (this._size != other._size) {
            return false;
        }
        if (this._atime != other._atime) {
            return false;
        }
        if (this._mtime != other._mtime) {
            return false;
        }
        if (this._ctime != other._ctime) {
            return false;
        }
        return this._crtime == other._crtime;
    }

    public boolean isDefined(StatAttributes attr) {
        return this._definedAttrs.contains((Object)attr);
    }

    private void guard(StatAttributes attr) throws IllegalStateException {
        if (!this.isDefined(attr)) {
            throw new IllegalStateException("Attribute is not defined: " + (Object)((Object)attr));
        }
    }

    private void define(StatAttributes attr) throws IllegalStateException {
        this._definedAttrs.add(attr);
    }

    public boolean isDefinedAny() {
        return !this._definedAttrs.isEmpty();
    }

    public static enum StatAttributes {
        DEV,
        INO,
        MODE,
        NLINK,
        UID,
        GID,
        RDEV,
        SIZE,
        FILEID,
        GENERATION,
        ATIME,
        MTIME,
        CTIME,
        CRTIME,
        BLK_SIZE;

    }
}

