/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.dcache.nfs.ChimeraNFSException;

class NameFilter {
    private static final Charset UTF8 = Charset.forName("UTF-8");

    private NameFilter() {
    }

    public static String convert(byte[] bytes) throws ChimeraNFSException {
        if (bytes.length == 0) {
            throw new ChimeraNFSException(22, "zero-length name");
        }
        if (bytes.length > 255) {
            throw new ChimeraNFSException(63, "file name too long");
        }
        try {
            CharsetDecoder cd = UTF8.newDecoder();
            cd.onMalformedInput(CodingErrorAction.REPORT);
            cd.onUnmappableCharacter(CodingErrorAction.REPORT);
            ByteBuffer uniBuf = ByteBuffer.wrap(bytes);
            CharBuffer charBuf = cd.decode(uniBuf);
            for (char c : charBuf.array()) {
                if (!Character.isSurrogate(c)) continue;
                throw new ChimeraNFSException(22, "invalid utf8 name");
            }
            String name2 = new String(charBuf.array(), 0, charBuf.length());
            if (name2.length() == 0) {
                throw new ChimeraNFSException(22, "bad path name");
            }
            if (name2.length() > 255) {
                throw new ChimeraNFSException(63, "name too long");
            }
            if (name2.equals(".") || name2.equals("..")) {
                throw new ChimeraNFSException(10041, "bad name '.' or '..'");
            }
            if (name2.indexOf(47) != -1) {
                throw new ChimeraNFSException(10041, "name with slash '/'");
            }
            return name2;
        }
        catch (CharacterCodingException e) {
            throw new ChimeraNFSException(22, "invalid utf8 name");
        }
    }
}

