/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.xdr.LOOKUPP4res;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationLOOKUPP
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationLOOKUPP.class);

    OperationLOOKUPP(nfs_argop4 args) {
        super(args, 16);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException {
        LOOKUPP4res res = result.oplookupp;
        Stat stat = context.getFs().getattr(context.currentInode());
        if (stat.type() == Stat.Type.SYMLINK) {
            throw new ChimeraNFSException(10029, "get parent on a symlink");
        }
        if (stat.type() != Stat.Type.DIRECTORY) {
            throw new ChimeraNFSException(20, "not a directory");
        }
        Inode parent = context.getFs().parentOf(context.currentInode());
        if (parent == null || context.currentInode().equals(context.getFs().getRootInode())) {
            res.status = 2;
        } else {
            context.currentInode(parent);
            res.status = 0;
        }
    }
}

