/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.xdr.READ4res;
import org.dcache.nfs.v4.xdr.READ4resok;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.vfs.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationREAD
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationREAD.class);

    public OperationREAD(nfs_argop4 args) {
        super(args, 25);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws IOException {
        READ4res res = result.opread;
        Stat inodeStat = context.getFs().getattr(context.currentInode());
        if (inodeStat.type() == Stat.Type.DIRECTORY) {
            throw new ChimeraNFSException(21, "path is a directory");
        }
        if (inodeStat.type() == Stat.Type.SYMLINK) {
            throw new ChimeraNFSException(22, "path is a symlink");
        }
        if (context.getMinorversion() == 0) {
            context.getStateHandler().updateClientLeaseTime(this._args.opread.stateid);
        }
        long offset = this._args.opread.offset.value;
        int count = this._args.opread.count.value;
        ByteBuffer buf = ByteBuffer.allocate(count);
        int bytesReaded = context.getFs().read(context.currentInode(), buf.array(), offset, count);
        if (bytesReaded < 0) {
            throw new ChimeraNFSException(5, "IO not allowd");
        }
        buf.position(bytesReaded);
        res.status = 0;
        res.resok4 = new READ4resok();
        res.resok4.data = buf;
        if (offset + (long)bytesReaded >= inodeStat.getSize()) {
            res.resok4.eof = true;
        }
    }
}

