/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.vfs;

public class Stat {
    public static final int S_TYPE = 258048;
    public static final int S_IFSOCK = 49152;
    public static final int S_IFLNK = 40960;
    public static final int S_IFREG = 32768;
    public static final int S_IFBLK = 24576;
    public static final int S_IFDIR = 16384;
    public static final int S_IFCHR = 8192;
    public static final int S_IFIFO = 4096;
    private int _dev = -1;
    private int _ino = -1;
    private int _mode = -1;
    private int _nlink = -1;
    private int _owner = -1;
    private int _group = -1;
    private int _rdev = -1;
    private long _size = -1L;
    private long _fileid = -1L;
    private long _generation = -1L;
    private long _atime = -1L;
    private long _mtime = -1L;
    private long _ctime = -1L;

    public int getDev() {
        return this._dev;
    }

    public void setDev(int dev) {
        this._dev = dev;
    }

    public int getIno() {
        return this._ino;
    }

    public void setIno(int ino) {
        this._ino = ino;
    }

    public int getMode() {
        return this._mode;
    }

    public void setMode(int mode) {
        this._mode = mode;
    }

    public int getNlink() {
        return this._nlink;
    }

    public void setNlink(int nlink) {
        this._nlink = nlink;
    }

    public int getUid() {
        return this._owner;
    }

    public void setUid(int owner) {
        this._owner = owner;
    }

    public int getGid() {
        return this._group;
    }

    public void setGid(int group) {
        this._group = group;
    }

    public int getRdev() {
        return this._rdev;
    }

    public void setRdev(int rdev) {
        this._rdev = rdev;
    }

    public long getSize() {
        return this._size;
    }

    public void setSize(long size) {
        this._size = size;
    }

    public long getATime() {
        return this._atime;
    }

    public void setATime(long atime) {
        this._atime = atime;
    }

    public long getMTime() {
        return this._mtime;
    }

    public void setMTime(long mtime) {
        this._mtime = mtime;
    }

    public long getCTime() {
        return this._ctime;
    }

    public void setCTime(long ctime) {
        this._ctime = ctime;
    }

    public long getFileId() {
        return this._fileid;
    }

    public void setFileid(long fileid) {
        this._fileid = fileid;
    }

    public long getGeneration() {
        return this._generation;
    }

    public void setGeneration(long generation) {
        this._generation = generation;
    }

    public Type type() {
        switch (this._mode & 0x3F000) {
            case 24576: {
                return Type.BLOCK;
            }
            case 8192: {
                return Type.CHAR;
            }
            case 16384: {
                return Type.DIRECTORY;
            }
            case 4096: {
                return Type.FIFO;
            }
            case 40960: {
                return Type.SYMLINK;
            }
            case 32768: {
                return Type.REGULAR;
            }
            case 49152: {
                return Type.SOCK;
            }
        }
        return Type.REGULAR;
    }

    public static enum Type {
        LEGACY,
        REGULAR,
        DIRECTORY,
        SYMLINK,
        CHAR,
        BLOCK,
        FIFO,
        SOCK;

    }
}

