/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr;

import org.dcache.xdr.OncRpcSvc;
import org.dcache.xdr.RpcMessageParserTCP;
import org.dcache.xdr.RpcMessageParserUDP;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.UDPNIOTransport;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;

public class GrizzlyUtils {
    private static final int MIN_SELECTORS = 2;
    private static final int MIN_WORKERS = 5;
    static final int CPUS = Runtime.getRuntime().availableProcessors();

    private GrizzlyUtils() {
    }

    public static Filter rpcMessageReceiverFor(Transport t) {
        if (t instanceof TCPNIOTransport) {
            return new RpcMessageParserTCP();
        }
        if (t instanceof UDPNIOTransport) {
            return new RpcMessageParserUDP();
        }
        throw new RuntimeException("Unsupported transport: " + t.getClass().getName());
    }

    public static Class<? extends Transport> transportFor(int protocol) {
        switch (protocol) {
            case 6: {
                return TCPNIOTransport.class;
            }
            case 17: {
                return UDPNIOTransport.class;
            }
        }
        throw new RuntimeException("Unsupported protocol: " + protocol);
    }

    private static int getSelectorPoolSize(OncRpcSvc.IoStrategy ioStrategy) {
        return ioStrategy == OncRpcSvc.IoStrategy.WORKER_THREAD ? Math.max(2, CPUS / 4) : Math.max(5, CPUS);
    }

    private static int getWorkerPoolSize(OncRpcSvc.IoStrategy ioStrategy) {
        return ioStrategy == OncRpcSvc.IoStrategy.WORKER_THREAD ? Math.max(5, CPUS * 2) : 0;
    }

    static ThreadPoolConfig getSelectorPoolCfg(OncRpcSvc.IoStrategy ioStrategy) {
        int poolSize = GrizzlyUtils.getSelectorPoolSize(ioStrategy);
        ThreadPoolConfig poolCfg = ThreadPoolConfig.defaultConfig();
        poolCfg.setCorePoolSize(poolSize).setMaxPoolSize(poolSize);
        poolCfg.setPoolName("OncRpcSvc");
        return poolCfg;
    }

    static ThreadPoolConfig getWorkerPoolCfg(OncRpcSvc.IoStrategy ioStrategy) {
        if (ioStrategy == OncRpcSvc.IoStrategy.SAME_THREAD) {
            return null;
        }
        int poolSize = GrizzlyUtils.getWorkerPoolSize(ioStrategy);
        ThreadPoolConfig poolCfg = ThreadPoolConfig.defaultConfig();
        poolCfg.setCorePoolSize(poolSize).setMaxPoolSize(poolSize);
        poolCfg.setPoolName("OncRpcSvc Worker");
        return poolCfg;
    }
}

