/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.tf.timer.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.pfl.tf.timer.impl.TimerFactoryImpl;
import org.glassfish.pfl.tf.timer.spi.ObjectRegistrationManager;
import org.glassfish.pfl.tf.timer.spi.TimerFactory;

public class TimerFactoryBuilder {
    private static Map<String, TimerFactory> fmap = new HashMap<String, TimerFactory>();

    public static String getTimerName(String cname, String name2) {
        return cname + "__" + name2;
    }

    public static synchronized TimerFactory make(String name2, String description) {
        return TimerFactoryBuilder.make(ObjectRegistrationManager.nullImpl, name2, description);
    }

    public static synchronized TimerFactory make(ObjectRegistrationManager orm, String name2, String description) {
        if (fmap.get(name2) != null) {
            throw new IllegalArgumentException("There is currently a TimerFactory named " + name2);
        }
        TimerFactoryImpl result = new TimerFactoryImpl(orm, name2, description);
        fmap.put(name2, result);
        return result;
    }

    public static synchronized void destroy(TimerFactory factory) {
        fmap.remove(factory.name());
    }

    public static synchronized List<TimerFactory> contents() {
        Collection<TimerFactory> coll = fmap.values();
        ArrayList<TimerFactory> list = new ArrayList<TimerFactory>(coll);
        return list;
    }
}

