/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.core;

import org.springframework.asm.Type;

public class Signature {
    private String name;
    private String desc;

    public Signature(String name2, String desc) {
        if (name2.indexOf(40) >= 0) {
            throw new IllegalArgumentException("Name '" + name2 + "' is invalid");
        }
        this.name = name2;
        this.desc = desc;
    }

    public Signature(String name2, Type returnType, Type[] argumentTypes) {
        this(name2, Type.getMethodDescriptor(returnType, argumentTypes));
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.desc;
    }

    public Type getReturnType() {
        return Type.getReturnType(this.desc);
    }

    public Type[] getArgumentTypes() {
        return Type.getArgumentTypes(this.desc);
    }

    public String toString() {
        return this.name + this.desc;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Signature)) {
            return false;
        }
        Signature other = (Signature)o;
        return this.name.equals(other.name) && this.desc.equals(other.desc);
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.desc.hashCode();
    }
}

