/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.Aware;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.BeanMethod;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ComponentScanAnnotationParser;
import org.springframework.context.annotation.ConditionEvaluator;
import org.springframework.context.annotation.ConfigurationClass;
import org.springframework.context.annotation.ConfigurationClassUtils;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.DeferredImportSelector;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.core.NestedIOException;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePropertySource;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardAnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

class ConfigurationClassParser {
    private static final Comparator<DeferredImportSelectorHolder> DEFERRED_IMPORT_COMPARATOR = new Comparator<DeferredImportSelectorHolder>(){

        @Override
        public int compare(DeferredImportSelectorHolder o1, DeferredImportSelectorHolder o2) {
            return AnnotationAwareOrderComparator.INSTANCE.compare(o1.getImportSelector(), o2.getImportSelector());
        }
    };
    private final MetadataReaderFactory metadataReaderFactory;
    private final ProblemReporter problemReporter;
    private final Environment environment;
    private final ResourceLoader resourceLoader;
    private final BeanDefinitionRegistry registry;
    private final ComponentScanAnnotationParser componentScanParser;
    private final Set<ConfigurationClass> configurationClasses = new LinkedHashSet<ConfigurationClass>();
    private final Map<String, ConfigurationClass> knownSuperclasses = new HashMap<String, ConfigurationClass>();
    private final MultiValueMap<String, org.springframework.core.env.PropertySource<?>> propertySources = new LinkedMultiValueMap();
    private final ImportStack importStack = new ImportStack();
    private final List<DeferredImportSelectorHolder> deferredImportSelectors = new LinkedList<DeferredImportSelectorHolder>();
    private final ConditionEvaluator conditionEvaluator;

    public ConfigurationClassParser(MetadataReaderFactory metadataReaderFactory, ProblemReporter problemReporter, Environment environment, ResourceLoader resourceLoader, BeanNameGenerator componentScanBeanNameGenerator, BeanDefinitionRegistry registry) {
        this.metadataReaderFactory = metadataReaderFactory;
        this.problemReporter = problemReporter;
        this.environment = environment;
        this.resourceLoader = resourceLoader;
        this.registry = registry;
        this.componentScanParser = new ComponentScanAnnotationParser(resourceLoader, environment, componentScanBeanNameGenerator, registry);
        this.conditionEvaluator = new ConditionEvaluator(registry, environment, resourceLoader);
    }

    public void parse(Set<BeanDefinitionHolder> configCandidates) {
        for (BeanDefinitionHolder holder : configCandidates) {
            BeanDefinition bd = holder.getBeanDefinition();
            try {
                if (bd instanceof AbstractBeanDefinition && ((AbstractBeanDefinition)bd).hasBeanClass()) {
                    this.parse(((AbstractBeanDefinition)bd).getBeanClass(), holder.getBeanName());
                    continue;
                }
                this.parse(bd.getBeanClassName(), holder.getBeanName());
            }
            catch (IOException ex) {
                throw new BeanDefinitionStoreException("Failed to load bean class: " + bd.getBeanClassName(), ex);
            }
        }
        this.processDeferredImportSelectors();
    }

    protected final void parse(String className, String beanName) throws IOException {
        MetadataReader reader = this.metadataReaderFactory.getMetadataReader(className);
        this.processConfigurationClass(new ConfigurationClass(reader, beanName));
    }

    protected final void parse(Class<?> clazz, String beanName) throws IOException {
        this.processConfigurationClass(new ConfigurationClass(clazz, beanName));
    }

    protected void processConfigurationClass(ConfigurationClass configClass) throws IOException {
        if (this.conditionEvaluator.shouldSkip(configClass.getMetadata(), ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION)) {
            return;
        }
        if (this.configurationClasses.contains(configClass) && configClass.getBeanName() != null) {
            this.configurationClasses.remove(configClass);
            Iterator<ConfigurationClass> it = this.knownSuperclasses.values().iterator();
            while (it.hasNext()) {
                if (!configClass.equals(it.next())) continue;
                it.remove();
            }
        }
        SourceClass sourceClass = this.asSourceClass(configClass);
        while ((sourceClass = this.doProcessConfigurationClass(configClass, sourceClass)) != null) {
        }
        this.configurationClasses.add(configClass);
    }

    protected final SourceClass doProcessConfigurationClass(ConfigurationClass configClass, SourceClass sourceClass) throws IOException {
        String superclass;
        this.processMemberClasses(configClass, sourceClass);
        for (AnnotationAttributes propertySource : AnnotationConfigUtils.attributesForRepeatable(sourceClass.getMetadata(), PropertySources.class, PropertySource.class)) {
            this.processPropertySource(propertySource);
        }
        AnnotationAttributes componentScan = AnnotationConfigUtils.attributesFor((AnnotatedTypeMetadata)sourceClass.getMetadata(), ComponentScan.class);
        if (componentScan != null && !this.conditionEvaluator.shouldSkip(sourceClass.getMetadata(), ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN)) {
            Set<BeanDefinitionHolder> scannedBeanDefinitions = this.componentScanParser.parse(componentScan, sourceClass.getMetadata().getClassName());
            for (BeanDefinitionHolder holder : scannedBeanDefinitions) {
                if (!ConfigurationClassUtils.checkConfigurationClassCandidate(holder.getBeanDefinition(), this.metadataReaderFactory)) continue;
                this.parse(holder.getBeanDefinition().getBeanClassName(), holder.getBeanName());
            }
        }
        this.processImports(configClass, sourceClass, this.getImports(sourceClass), true);
        if (sourceClass.getMetadata().isAnnotated(ImportResource.class.getName())) {
            AnnotationAttributes importResource = AnnotationConfigUtils.attributesFor((AnnotatedTypeMetadata)sourceClass.getMetadata(), ImportResource.class);
            String[] resources = importResource.getStringArray("value");
            Class readerClass = importResource.getClass("reader");
            for (Object object : resources) {
                String resolvedResource = this.environment.resolveRequiredPlaceholders((String)object);
                configClass.addImportedResource(resolvedResource, readerClass);
            }
        }
        Set<MethodMetadata> beanMethods = sourceClass.getMetadata().getAnnotatedMethods(Bean.class.getName());
        for (MethodMetadata methodMetadata : beanMethods) {
            configClass.addBeanMethod(new BeanMethod(methodMetadata, configClass));
        }
        if (sourceClass.getMetadata().hasSuperClass() && !this.knownSuperclasses.containsKey(superclass = sourceClass.getMetadata().getSuperClassName())) {
            this.knownSuperclasses.put(superclass, configClass);
            try {
                return sourceClass.getSuperClass();
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return null;
    }

    private void processMemberClasses(ConfigurationClass configClass, SourceClass sourceClass) throws IOException {
        for (SourceClass memberClass : sourceClass.getMemberClasses()) {
            if (!ConfigurationClassUtils.isConfigurationCandidate(memberClass.getMetadata())) continue;
            this.processConfigurationClass(memberClass.asConfigClass(configClass));
        }
    }

    private void processPropertySource(AnnotationAttributes propertySource) throws IOException {
        String name2 = propertySource.getString("name");
        String[] locations = propertySource.getStringArray("value");
        boolean ignoreResourceNotFound = propertySource.getBoolean("ignoreResourceNotFound");
        int locationCount = locations.length;
        if (locationCount == 0) {
            throw new IllegalArgumentException("At least one @PropertySource(value) location is required");
        }
        for (String location : locations) {
            try {
                Resource resource = this.resourceLoader.getResource(this.environment.resolveRequiredPlaceholders(location));
                if (!StringUtils.hasText(name2) || this.propertySources.containsKey(name2)) {
                    ResourcePropertySource ps = new ResourcePropertySource(resource);
                    this.propertySources.add(StringUtils.hasText(name2) ? name2 : ps.getName(), ps);
                    continue;
                }
                this.propertySources.add(name2, new ResourcePropertySource(name2, resource));
            }
            catch (IllegalArgumentException ex) {
                if (ignoreResourceNotFound) continue;
                throw ex;
            }
            catch (FileNotFoundException ex) {
                if (ignoreResourceNotFound) continue;
                throw ex;
            }
        }
    }

    private Set<SourceClass> getImports(SourceClass sourceClass) throws IOException {
        LinkedHashSet<SourceClass> imports = new LinkedHashSet<SourceClass>();
        LinkedHashSet<SourceClass> visited = new LinkedHashSet<SourceClass>();
        this.collectImports(sourceClass, imports, visited);
        return imports;
    }

    private void collectImports(SourceClass sourceClass, Set<SourceClass> imports, Set<SourceClass> visited) throws IOException {
        try {
            if (visited.add(sourceClass)) {
                for (SourceClass annotation : sourceClass.getAnnotations()) {
                    String annName = annotation.getMetadata().getClassName();
                    if (annName.startsWith("java") || annName.equals(Import.class.getName())) continue;
                    this.collectImports(annotation, imports, visited);
                }
                imports.addAll(sourceClass.getAnnotationAttributes(Import.class.getName(), "value"));
            }
        }
        catch (ClassNotFoundException ex) {
            throw new NestedIOException("Unable to collect imports", ex);
        }
    }

    private void processDeferredImportSelectors() {
        Collections.sort(this.deferredImportSelectors, DEFERRED_IMPORT_COMPARATOR);
        for (DeferredImportSelectorHolder deferredImport : this.deferredImportSelectors) {
            try {
                ConfigurationClass configClass = deferredImport.getConfigurationClass();
                String[] imports = deferredImport.getImportSelector().selectImports(configClass.getMetadata());
                this.processImports(configClass, this.asSourceClass(configClass), this.asSourceClasses(imports), false);
            }
            catch (Exception ex) {
                throw new BeanDefinitionStoreException("Failed to load bean class: ", ex);
            }
        }
        this.deferredImportSelectors.clear();
    }

    private void processImports(ConfigurationClass configClass, SourceClass currentSourceClass, Collection<SourceClass> importCandidates, boolean checkForCircularImports) throws IOException {
        if (importCandidates.isEmpty()) {
            return;
        }
        if (checkForCircularImports && this.importStack.contains(configClass)) {
            this.problemReporter.error(new CircularImportProblem(configClass, this.importStack, configClass.getMetadata()));
        } else {
            this.importStack.push(configClass);
            try {
                for (SourceClass candidate : importCandidates) {
                    Class<?> candidateClass;
                    if (candidate.isAssignable(ImportSelector.class)) {
                        candidateClass = candidate.loadClass();
                        ImportSelector selector = BeanUtils.instantiateClass(candidateClass, ImportSelector.class);
                        this.invokeAwareMethods(selector);
                        if (selector instanceof DeferredImportSelector) {
                            this.deferredImportSelectors.add(new DeferredImportSelectorHolder(configClass, (DeferredImportSelector)selector));
                            continue;
                        }
                        String[] importClassNames = selector.selectImports(currentSourceClass.getMetadata());
                        Collection<SourceClass> importSourceClasses = this.asSourceClasses(importClassNames);
                        this.processImports(configClass, currentSourceClass, importSourceClasses, false);
                        continue;
                    }
                    if (candidate.isAssignable(ImportBeanDefinitionRegistrar.class)) {
                        candidateClass = candidate.loadClass();
                        ImportBeanDefinitionRegistrar registrar = BeanUtils.instantiateClass(candidateClass, ImportBeanDefinitionRegistrar.class);
                        this.invokeAwareMethods(registrar);
                        configClass.addImportBeanDefinitionRegistrar(registrar, currentSourceClass.getMetadata());
                        continue;
                    }
                    this.importStack.registerImport(currentSourceClass.getMetadata(), candidate.getMetadata().getClassName());
                    this.processConfigurationClass(candidate.asConfigClass(configClass));
                }
            }
            catch (ClassNotFoundException ex) {
                throw new NestedIOException("Failed to load import candidate class", ex);
            }
            finally {
                this.importStack.pop();
            }
        }
    }

    private void invokeAwareMethods(Object importStrategyBean) {
        if (importStrategyBean instanceof Aware) {
            if (importStrategyBean instanceof EnvironmentAware) {
                ((EnvironmentAware)importStrategyBean).setEnvironment(this.environment);
            }
            if (importStrategyBean instanceof ResourceLoaderAware) {
                ((ResourceLoaderAware)importStrategyBean).setResourceLoader(this.resourceLoader);
            }
            if (importStrategyBean instanceof BeanClassLoaderAware) {
                ClassLoader classLoader = this.registry instanceof ConfigurableBeanFactory ? ((ConfigurableBeanFactory)((Object)this.registry)).getBeanClassLoader() : this.resourceLoader.getClassLoader();
                ((BeanClassLoaderAware)importStrategyBean).setBeanClassLoader(classLoader);
            }
            if (importStrategyBean instanceof BeanFactoryAware && this.registry instanceof BeanFactory) {
                ((BeanFactoryAware)importStrategyBean).setBeanFactory((BeanFactory)((Object)this.registry));
            }
        }
    }

    public void validate() {
        for (ConfigurationClass configClass : this.configurationClasses) {
            configClass.validate(this.problemReporter);
        }
    }

    public Set<ConfigurationClass> getConfigurationClasses() {
        return this.configurationClasses;
    }

    public List<org.springframework.core.env.PropertySource<?>> getPropertySources() {
        LinkedList propertySources = new LinkedList();
        for (Map.Entry entry : this.propertySources.entrySet()) {
            propertySources.add(0, this.collatePropertySources((String)entry.getKey(), (List)entry.getValue()));
        }
        return propertySources;
    }

    private org.springframework.core.env.PropertySource<?> collatePropertySources(String name2, List<org.springframework.core.env.PropertySource<?>> propertySources) {
        if (propertySources.size() == 1) {
            return propertySources.get(0);
        }
        CompositePropertySource result = new CompositePropertySource(name2);
        for (int i = propertySources.size() - 1; i >= 0; --i) {
            result.addPropertySource(propertySources.get(i));
        }
        return result;
    }

    ImportRegistry getImportRegistry() {
        return this.importStack;
    }

    public SourceClass asSourceClass(ConfigurationClass configurationClass) throws IOException {
        try {
            AnnotationMetadata metadata = configurationClass.getMetadata();
            if (metadata instanceof StandardAnnotationMetadata) {
                return this.asSourceClass(((StandardAnnotationMetadata)metadata).getIntrospectedClass());
            }
            return this.asSourceClass(configurationClass.getMetadata().getClassName());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public SourceClass asSourceClass(Class<?> classType) throws IOException, ClassNotFoundException {
        try {
            classType.getAnnotations();
            return new SourceClass(classType);
        }
        catch (Throwable ex) {
            return this.asSourceClass(classType.getName());
        }
    }

    public Collection<SourceClass> asSourceClasses(String[] classNames) throws IOException, ClassNotFoundException {
        ArrayList<SourceClass> annotatedClasses = new ArrayList<SourceClass>();
        for (String className : classNames) {
            annotatedClasses.add(this.asSourceClass(className));
        }
        return annotatedClasses;
    }

    public SourceClass asSourceClass(String className) throws IOException, ClassNotFoundException {
        if (className.startsWith("java")) {
            return new SourceClass(this.resourceLoader.getClassLoader().loadClass(className));
        }
        return new SourceClass(this.metadataReaderFactory.getMetadataReader(className));
    }

    private static class CircularImportProblem
    extends Problem {
        public CircularImportProblem(ConfigurationClass attemptedImport, Stack<ConfigurationClass> importStack, AnnotationMetadata metadata) {
            super(String.format("A circular @Import has been detected: Illegal attempt by @Configuration class '%s' to import class '%s' as '%s' is already present in the current import stack [%s]", importStack.peek().getSimpleName(), attemptedImport.getSimpleName(), attemptedImport.getSimpleName(), importStack), new Location(importStack.peek().getResource(), metadata));
        }
    }

    private class SourceClass {
        private final Object source;
        private final AnnotationMetadata metadata;

        public SourceClass(Object source) {
            this.source = source;
            this.metadata = source instanceof Class ? new StandardAnnotationMetadata((Class)source, true) : ((MetadataReader)source).getAnnotationMetadata();
        }

        public final AnnotationMetadata getMetadata() {
            return this.metadata;
        }

        public Class<?> loadClass() throws ClassNotFoundException {
            if (this.source instanceof Class) {
                return (Class)this.source;
            }
            String className = ((MetadataReader)this.source).getClassMetadata().getClassName();
            return ConfigurationClassParser.this.resourceLoader.getClassLoader().loadClass(className);
        }

        public boolean isAssignable(Class<?> clazz) throws IOException {
            if (this.source instanceof Class) {
                return clazz.isAssignableFrom((Class)this.source);
            }
            return new AssignableTypeFilter(clazz).match((MetadataReader)this.source, ConfigurationClassParser.this.metadataReaderFactory);
        }

        public ConfigurationClass asConfigClass(ConfigurationClass importedBy) throws IOException {
            if (this.source instanceof Class) {
                return new ConfigurationClass((Class)this.source, importedBy);
            }
            return new ConfigurationClass((MetadataReader)this.source, importedBy);
        }

        public Collection<SourceClass> getMemberClasses() throws IOException {
            ArrayList<SourceClass> members = new ArrayList<SourceClass>();
            if (this.source instanceof Class) {
                Class sourceClass = (Class)this.source;
                for (Class<?> declaredClass : sourceClass.getDeclaredClasses()) {
                    try {
                        members.add(ConfigurationClassParser.this.asSourceClass(declaredClass));
                    }
                    catch (ClassNotFoundException ex) {
                        // empty catch block
                    }
                }
            } else {
                MetadataReader sourceReader = (MetadataReader)this.source;
                for (String memberClassName : sourceReader.getClassMetadata().getMemberClassNames()) {
                    try {
                        members.add(ConfigurationClassParser.this.asSourceClass(memberClassName));
                    }
                    catch (ClassNotFoundException ex) {
                        // empty catch block
                    }
                }
            }
            return members;
        }

        public SourceClass getSuperClass() throws IOException, ClassNotFoundException {
            if (this.source instanceof Class) {
                return ConfigurationClassParser.this.asSourceClass(((Class)this.source).getSuperclass());
            }
            return ConfigurationClassParser.this.asSourceClass(((MetadataReader)this.source).getClassMetadata().getSuperClassName());
        }

        public Set<SourceClass> getAnnotations() throws IOException {
            LinkedHashSet<SourceClass> result = new LinkedHashSet<SourceClass>();
            for (String className : this.metadata.getAnnotationTypes()) {
                try {
                    result.add(this.getRelated(className));
                }
                catch (Throwable ex) {}
            }
            return result;
        }

        public Collection<SourceClass> getAnnotationAttributes(String annotationType, String attribute) throws IOException, ClassNotFoundException {
            Map<String, Object> annotationAttributes = this.metadata.getAnnotationAttributes(annotationType, true);
            if (annotationAttributes == null || !annotationAttributes.containsKey(attribute)) {
                return Collections.emptySet();
            }
            String[] classNames = (String[])annotationAttributes.get(attribute);
            LinkedHashSet<SourceClass> result = new LinkedHashSet<SourceClass>();
            for (String className : classNames) {
                result.add(this.getRelated(className));
            }
            return result;
        }

        private SourceClass getRelated(String className) throws IOException, ClassNotFoundException {
            if (this.source instanceof Class) {
                try {
                    Class<?> clazz = ConfigurationClassParser.this.resourceLoader.getClassLoader().loadClass(className);
                    return ConfigurationClassParser.this.asSourceClass(clazz);
                }
                catch (ClassNotFoundException ex) {
                    if (className.startsWith("java")) {
                        throw ex;
                    }
                    return new SourceClass(ConfigurationClassParser.this.metadataReaderFactory.getMetadataReader(className));
                }
            }
            return ConfigurationClassParser.this.asSourceClass(className);
        }

        public boolean equals(Object other) {
            return this == other || other instanceof SourceClass && this.metadata.getClassName().equals(((SourceClass)other).metadata.getClassName());
        }

        public int hashCode() {
            return this.metadata.getClassName().hashCode();
        }

        public String toString() {
            return this.metadata.getClassName();
        }
    }

    private static class DeferredImportSelectorHolder {
        private final ConfigurationClass configurationClass;
        private final DeferredImportSelector importSelector;

        public DeferredImportSelectorHolder(ConfigurationClass configurationClass, DeferredImportSelector importSelector) {
            this.configurationClass = configurationClass;
            this.importSelector = importSelector;
        }

        public ConfigurationClass getConfigurationClass() {
            return this.configurationClass;
        }

        public DeferredImportSelector getImportSelector() {
            return this.importSelector;
        }
    }

    private static class ImportStack
    extends Stack<ConfigurationClass>
    implements ImportRegistry {
        private final Map<String, AnnotationMetadata> imports = new HashMap<String, AnnotationMetadata>();

        private ImportStack() {
        }

        public void registerImport(AnnotationMetadata importingClass, String importedClass) {
            this.imports.put(importedClass, importingClass);
        }

        @Override
        public AnnotationMetadata getImportingClassFor(String importedClass) {
            return this.imports.get(importedClass);
        }

        @Override
        public boolean contains(Object elem) {
            ConfigurationClass configClass = (ConfigurationClass)elem;
            Comparator<ConfigurationClass> comparator = new Comparator<ConfigurationClass>(){

                @Override
                public int compare(ConfigurationClass first, ConfigurationClass second) {
                    return first.getMetadata().getClassName().equals(second.getMetadata().getClassName()) ? 0 : 1;
                }
            };
            return Collections.binarySearch(this, configClass, comparator) != -1;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder("ImportStack: [");
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                builder.append(((ConfigurationClass)iterator.next()).getSimpleName());
                if (!iterator.hasNext()) continue;
                builder.append("->");
            }
            return builder.append(']').toString();
        }
    }

    static interface ImportRegistry {
        public AnnotationMetadata getImportingClassFor(String var1);
    }
}

