/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;

public abstract class EnumerablePropertySource<T>
extends PropertySource<T> {
    protected static final String[] EMPTY_NAMES_ARRAY = new String[0];
    protected final Log logger = LogFactory.getLog(this.getClass());

    public EnumerablePropertySource(String name2, T source) {
        super(name2, source);
    }

    public abstract String[] getPropertyNames();

    @Override
    public boolean containsProperty(String name2) {
        Assert.notNull(name2, "property name must not be null");
        for (String candidate : this.getPropertyNames()) {
            if (!candidate.equals(name2)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("PropertySource [%s] contains '%s'", this.getName(), name2));
            }
            return true;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(String.format("PropertySource [%s] does not contain '%s'", this.getName(), name2));
        }
        return false;
    }
}

