/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.io.IOException;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.StringUtils;

public class ResourcePropertySource
extends PropertiesPropertySource {
    public ResourcePropertySource(String name2, EncodedResource resource) throws IOException {
        super(name2, PropertiesLoaderUtils.loadProperties(resource));
    }

    public ResourcePropertySource(EncodedResource resource) throws IOException {
        this(ResourcePropertySource.getNameForResource(resource.getResource()), resource);
    }

    public ResourcePropertySource(String name2, Resource resource) throws IOException {
        super(name2, PropertiesLoaderUtils.loadProperties(new EncodedResource(resource)));
    }

    public ResourcePropertySource(Resource resource) throws IOException {
        this(ResourcePropertySource.getNameForResource(resource), resource);
    }

    public ResourcePropertySource(String name2, String location, ClassLoader classLoader) throws IOException {
        this(name2, new DefaultResourceLoader(classLoader).getResource(location));
    }

    public ResourcePropertySource(String location, ClassLoader classLoader) throws IOException {
        this(new DefaultResourceLoader(classLoader).getResource(location));
    }

    public ResourcePropertySource(String name2, String location) throws IOException {
        this(name2, new DefaultResourceLoader().getResource(location));
    }

    public ResourcePropertySource(String location) throws IOException {
        this(new DefaultResourceLoader().getResource(location));
    }

    private static String getNameForResource(Resource resource) {
        String name2 = resource.getDescription();
        if (!StringUtils.hasText(name2)) {
            name2 = resource.getClass().getSimpleName() + "@" + System.identityHashCode(resource);
        }
        return name2;
    }
}

