/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4.nlm;

import com.google.common.io.BaseEncoding;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MultiMap;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.dcache.nfs.v4.nlm.AbstractLockManager;
import org.dcache.nfs.v4.nlm.NlmLock;

public class DistributedLockManager
extends AbstractLockManager {
    private final MultiMap<String, NlmLock> locks;

    public DistributedLockManager(HazelcastInstance hz, String name) {
        this.locks = hz.getMultiMap(name);
    }

    protected Lock getObjectLock(byte[] objId) {
        final String key = BaseEncoding.base16().upperCase().encode(objId);
        return new Lock(){

            @Override
            public void lock() {
                DistributedLockManager.this.locks.lock((Object)key);
            }

            @Override
            public void lockInterruptibly() throws InterruptedException {
                DistributedLockManager.this.locks.tryLock((Object)key, Long.MAX_VALUE, TimeUnit.DAYS);
            }

            @Override
            public boolean tryLock() {
                return DistributedLockManager.this.locks.tryLock((Object)key);
            }

            @Override
            public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
                return DistributedLockManager.this.locks.tryLock((Object)key, time, unit);
            }

            @Override
            public void unlock() {
                DistributedLockManager.this.locks.unlock((Object)key);
            }

            @Override
            public Condition newCondition() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    protected Collection<NlmLock> getActiveLocks(byte[] objId) {
        String key = DistributedLockManager.objIdToKey(objId);
        return this.locks.get((Object)key);
    }

    protected void add(byte[] objId, NlmLock lock) {
        String key = DistributedLockManager.objIdToKey(objId);
        this.locks.put((Object)key, (Object)lock);
    }

    protected boolean remove(byte[] objId, NlmLock lock) {
        String key = DistributedLockManager.objIdToKey(objId);
        return this.locks.remove((Object)key, (Object)lock);
    }

    protected void addAll(byte[] objId, Collection<NlmLock> locks) {
        String key = DistributedLockManager.objIdToKey(objId);
        locks.forEach(l -> this.locks.put((Object)key, l));
    }

    protected void removeAll(byte[] objId, Collection<NlmLock> locks) {
        String key = DistributedLockManager.objIdToKey(objId);
        locks.forEach(l -> this.locks.remove((Object)key, l));
    }

    private static String objIdToKey(byte[] objId) {
        return BaseEncoding.base64().omitPadding().encode(objId);
    }
}

