/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.DumpFileReader;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.FileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.Provisional;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class StatsFileReader
extends DumpFileReader {
    private final Map<LogEntryType, EntryInfo> entryInfoMap = new TreeMap<LogEntryType, EntryInfo>(new LogEntryTypeComparator());
    private long totalLogBytes = 0L;
    private long totalCount = 0L;
    private final ArrayList<CheckpointCounter> ckptList;
    private CheckpointCounter ckptCounter = new CheckpointCounter();
    private long firstLsnRead;
    private long realTotalKeyCount = 0L;
    private long realTotalKeyBytes = 0L;
    private long realMinKeyBytes = 0L;
    private long realMaxKeyBytes = 0L;
    private long realTotalDataCount = 0L;
    private long realTotalDataBytes = 0L;
    private long realMinDataBytes = 0L;
    private long realMaxDataBytes = 0L;

    public StatsFileReader(EnvironmentImpl envImpl, int readBufferSize, long startLsn, long finishLsn, long endOfFileLsn, String entryTypes, String txnIds, boolean verbose, boolean repEntriesOnly, boolean forwards) throws DatabaseException {
        super(envImpl, readBufferSize, startLsn, finishLsn, endOfFileLsn, entryTypes, txnIds, verbose, repEntriesOnly, forwards);
        this.ckptList = new ArrayList();
        if (verbose) {
            this.ckptList.add(this.ckptCounter);
        }
    }

    @Override
    protected boolean processEntry(ByteBuffer entryBuffer) {
        byte currentType = this.currentEntryHeader.getType();
        int itemSize = this.currentEntryHeader.getItemSize();
        int headerSize = this.currentEntryHeader.getSize();
        LogEntryType lastEntryType = LogEntryType.findType(currentType);
        int nextEntryPosition = entryBuffer.position() + itemSize;
        EntryInfo info = this.entryInfoMap.get(lastEntryType);
        if (info == null) {
            info = new EntryInfo();
            this.entryInfoMap.put(lastEntryType, info);
        }
        ++info.count;
        ++this.totalCount;
        if (this.currentEntryHeader.getProvisional() == Provisional.YES) {
            ++info.provisionalCount;
        }
        int size = itemSize + headerSize;
        info.totalBytes += (long)size;
        info.headerBytes += headerSize;
        this.totalLogBytes += (long)size;
        if (info.minBytes == 0 || info.minBytes > size) {
            info.minBytes = size;
        }
        if (info.maxBytes < size) {
            info.maxBytes = size;
        }
        if (this.verbose) {
            if (this.firstLsnRead == -1L) {
                this.firstLsnRead = this.getLastLsn();
            }
            if (currentType == LogEntryType.LOG_CKPT_END.getTypeNum()) {
                this.ckptCounter.endCkptLsn = this.getLastLsn();
                this.ckptCounter = new CheckpointCounter();
                this.ckptList.add(this.ckptCounter);
            } else {
                this.ckptCounter.increment(this, currentType);
            }
        }
        if (lastEntryType.isUserLNType()) {
            LNLogEntry entry = (LNLogEntry)lastEntryType.getSharedLogEntry();
            entry.readEntry(this.envImpl, this.currentEntryHeader, entryBuffer);
            int keyLen = entry.getUnconvertedKeyLength();
            this.realTotalKeyBytes += (long)keyLen;
            ++this.realTotalKeyCount;
            if (this.realMinKeyBytes == 0L || this.realMinKeyBytes > (long)keyLen) {
                this.realMinKeyBytes = keyLen;
            }
            if (this.realMaxKeyBytes < (long)keyLen) {
                this.realMaxKeyBytes = keyLen;
            }
            if (!entry.isDeleted()) {
                int dataLen = entry.getUnconvertedDataLength();
                this.realTotalDataBytes += (long)dataLen;
                ++this.realTotalDataCount;
                if (this.realMinDataBytes == 0L || this.realMinDataBytes > (long)dataLen) {
                    this.realMinDataBytes = dataLen;
                }
                if (this.realMaxDataBytes < (long)dataLen) {
                    this.realMaxDataBytes = dataLen;
                }
            }
        }
        entryBuffer.position(nextEntryPosition);
        return true;
    }

    @Override
    public void summarize(boolean csvFormat) {
        if (csvFormat) {
            this.summarizeCSV();
        } else {
            this.summarizeText();
        }
    }

    private void summarizeCSV() {
        Iterator<Map.Entry<LogEntryType, EntryInfo>> iter2 = this.entryInfoMap.entrySet().iterator();
        NumberFormat form = NumberFormat.getIntegerInstance();
        NumberFormat percentForm = NumberFormat.getInstance();
        percentForm.setMaximumFractionDigits(1);
        System.out.println("type,total count,provisional count,total bytes,min bytes,max bytes,avg bytes,entries as % of log");
        while (iter2.hasNext()) {
            Map.Entry<LogEntryType, EntryInfo> m4 = iter2.next();
            EntryInfo info = m4.getValue();
            StringBuilder sb = new StringBuilder();
            LogEntryType entryType = m4.getKey();
            sb.append(entryType.toString()).append(',');
            sb.append(info.count).append(',');
            sb.append(info.provisionalCount).append(',');
            sb.append(info.totalBytes).append(',');
            sb.append(info.minBytes).append(',');
            sb.append(info.maxBytes).append(',');
            sb.append(info.totalBytes / (long)info.count).append(',');
            double entryPercent = (double)(info.totalBytes * 100L) / (double)this.totalLogBytes;
            sb.append(entryPercent);
            System.out.println(sb.toString());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("key bytes,");
        sb.append(this.realTotalKeyCount).append(',');
        sb.append(",");
        sb.append(this.realTotalKeyBytes).append(',');
        sb.append(this.realMinKeyBytes).append(',');
        sb.append(this.realMaxKeyBytes).append(',');
        sb.append(this.realTotalKeyBytes / this.realTotalKeyCount).append(',');
        sb.append((double)(this.realTotalKeyBytes * 100L) / (double)this.totalLogBytes);
        System.out.println(sb.toString());
        sb = new StringBuilder();
        sb.append("data bytes,");
        sb.append(this.realTotalDataCount).append(',');
        sb.append(",");
        sb.append(this.realTotalDataBytes).append(',');
        sb.append(this.realMinDataBytes).append(',');
        sb.append(this.realMaxDataBytes).append(',');
        sb.append(this.realTotalDataBytes / this.realTotalDataCount).append(',');
        sb.append((double)(this.realTotalDataBytes * 100L) / (double)this.totalLogBytes);
        System.out.println(sb.toString());
        System.out.println("\nTotal bytes in portion of log read: " + form.format(this.totalLogBytes));
        System.out.println("Total number of entries: " + form.format(this.totalCount));
        if (this.verbose) {
            this.summarizeCheckpointInfo(new CheckpointInfoCSVFormatter());
        }
    }

    private void summarizeText() {
        System.out.println("Log statistics:");
        Iterator<Map.Entry<LogEntryType, EntryInfo>> iter2 = this.entryInfoMap.entrySet().iterator();
        NumberFormat form = NumberFormat.getIntegerInstance();
        NumberFormat percentForm = NumberFormat.getInstance();
        percentForm.setMaximumFractionDigits(1);
        System.out.println(this.pad("type") + this.pad("total") + this.pad("provisional") + this.pad("total") + this.pad("min") + this.pad("max") + this.pad("avg") + this.pad("entries"));
        System.out.println(this.pad("") + this.pad("count") + this.pad("count") + this.pad("bytes") + this.pad("bytes") + this.pad("bytes") + this.pad("bytes") + this.pad("as % of log"));
        while (iter2.hasNext()) {
            Map.Entry<LogEntryType, EntryInfo> m4 = iter2.next();
            EntryInfo info = m4.getValue();
            StringBuilder sb = new StringBuilder();
            LogEntryType entryType = m4.getKey();
            sb.append(this.pad(entryType.toString()));
            sb.append(this.pad(form.format(info.count)));
            sb.append(this.pad(form.format(info.provisionalCount)));
            sb.append(this.pad(form.format(info.totalBytes)));
            sb.append(this.pad(form.format(info.minBytes)));
            sb.append(this.pad(form.format(info.maxBytes)));
            sb.append(this.pad(form.format(info.totalBytes / (long)info.count)));
            double entryPercent = (double)(info.totalBytes * 100L) / (double)this.totalLogBytes;
            sb.append(this.pad(percentForm.format(entryPercent)));
            System.out.println(sb.toString());
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.pad("key bytes"));
        sb.append(this.pad(form.format(this.realTotalKeyCount)));
        sb.append(this.pad(""));
        sb.append(this.pad(form.format(this.realTotalKeyBytes)));
        sb.append(this.pad(form.format(this.realMinKeyBytes)));
        sb.append(this.pad(form.format(this.realMaxKeyBytes)));
        sb.append(this.pad(form.format(this.realTotalKeyBytes / this.realTotalKeyCount)));
        String realSize = "(" + percentForm.format((double)(this.realTotalKeyBytes * 100L) / (double)this.totalLogBytes) + ")";
        sb.append(this.pad(realSize));
        System.out.println(sb.toString());
        sb = new StringBuilder();
        sb.append(this.pad("data bytes"));
        sb.append(this.pad(form.format(this.realTotalDataCount)));
        sb.append(this.pad(""));
        sb.append(this.pad(form.format(this.realTotalDataBytes)));
        sb.append(this.pad(form.format(this.realMinDataBytes)));
        sb.append(this.pad(form.format(this.realMaxDataBytes)));
        sb.append(this.pad(form.format(this.realTotalDataBytes / this.realTotalDataCount)));
        realSize = "(" + percentForm.format((double)(this.realTotalDataBytes * 100L) / (double)this.totalLogBytes) + ")";
        sb.append(this.pad(realSize));
        System.out.println(sb.toString());
        System.out.println("\nTotal bytes in portion of log read: " + form.format(this.totalLogBytes));
        System.out.println("Total number of entries: " + form.format(this.totalCount));
        if (this.verbose) {
            this.summarizeCheckpointInfo(new CheckpointInfoTextFormatter(form));
        }
    }

    private String pad(String result) {
        int spaces = 20 - result.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < spaces; ++i) {
            sb.append(" ");
        }
        sb.append(result);
        return sb.toString();
    }

    private void summarizeCheckpointInfo(CheckpointInfoTextFormatter f) {
        System.out.println("\nPer checkpoint interval info:");
        System.out.println(f.format("lnTxn") + f.format("ln") + f.format("mapLNTxn") + f.format("mapLN") + f.format("end to end") + f.format("end to start") + f.format("start to end") + f.format("maxLNReplay") + f.format("ckptEnd"));
        long logFileMax = this.envImpl.getConfigManager().getLong(EnvironmentParams.LOG_FILE_MAX);
        Iterator<CheckpointCounter> iter2 = this.ckptList.iterator();
        CheckpointCounter prevCounter = null;
        while (iter2.hasNext()) {
            CheckpointCounter c = iter2.next();
            StringBuilder sb = new StringBuilder();
            int maxTxnLNs = c.preStartLNTxnCount + c.postStartLNTxnCount;
            sb.append(f.format(maxTxnLNs));
            int maxLNs = c.preStartLNCount + c.postStartLNCount;
            sb.append(f.format(maxLNs));
            sb.append(f.format(c.preStartMapLNTxnCount + c.postStartMapLNTxnCount));
            sb.append(f.format(c.preStartMapLNCount + c.postStartMapLNCount));
            long end = c.endCkptLsn == -1L ? this.getLastLsn() : c.endCkptLsn;
            long endToEndDistance = 0L;
            FileManager fileMgr = this.envImpl.getFileManager();
            endToEndDistance = prevCounter == null ? DbLsn.getWithCleaningDistance(end, this.firstLsnRead, logFileMax, fileMgr) : DbLsn.getWithCleaningDistance(end, prevCounter.endCkptLsn, logFileMax, fileMgr);
            sb.append(f.format(endToEndDistance));
            long start = c.startCkptLsn == -1L ? this.getLastLsn() : c.startCkptLsn;
            long endToStartDistance = 0L;
            endToStartDistance = prevCounter == null ? DbLsn.getWithCleaningDistance(start, this.firstLsnRead, logFileMax, fileMgr) : DbLsn.getWithCleaningDistance(start, prevCounter.endCkptLsn, logFileMax, fileMgr);
            sb.append(f.format(endToStartDistance));
            long startToEndDistance = 0L;
            if (c.startCkptLsn != -1L && c.endCkptLsn != -1L) {
                startToEndDistance = DbLsn.getWithCleaningDistance(c.endCkptLsn, c.startCkptLsn, logFileMax, fileMgr);
            }
            sb.append(f.format(startToEndDistance));
            int maxReplay = maxLNs + maxTxnLNs;
            if (prevCounter != null) {
                maxReplay += prevCounter.postStartLNTxnCount;
                maxReplay += prevCounter.postStartLNCount;
            }
            sb.append(f.format(maxReplay));
            if (c.endCkptLsn == -1L) {
                sb.append("   ").append(DbLsn.getNoFormatString(this.getLastLsn()));
            } else {
                sb.append("   ").append(DbLsn.getNoFormatString(c.endCkptLsn));
            }
            System.out.println(sb.toString());
            prevCounter = c;
        }
    }

    static class CheckpointCounter {
        public long startCkptLsn = -1L;
        public long endCkptLsn = -1L;
        public int preStartLNTxnCount;
        public int preStartLNCount;
        public int preStartMapLNTxnCount;
        public int preStartMapLNCount;
        public int postStartLNTxnCount;
        public int postStartLNCount;
        public int postStartMapLNTxnCount;
        public int postStartMapLNCount;

        CheckpointCounter() {
        }

        public void increment(FileReader reader, byte currentEntryTypeNum) {
            LogEntryType entryType = LogEntryType.findType(currentEntryTypeNum);
            if (entryType == LogEntryType.LOG_CKPT_START) {
                this.startCkptLsn = reader.getLastLsn();
            } else if (entryType.isUserLNType()) {
                if (entryType.isTransactional()) {
                    if (this.startCkptLsn == -1L) {
                        ++this.preStartLNTxnCount;
                    } else {
                        ++this.postStartLNTxnCount;
                    }
                } else if (this.startCkptLsn == -1L) {
                    ++this.preStartLNCount;
                } else {
                    ++this.postStartLNCount;
                }
            } else if (entryType == LogEntryType.LOG_MAPLN) {
                if (this.startCkptLsn == -1L) {
                    ++this.preStartMapLNCount;
                } else {
                    ++this.postStartMapLNCount;
                }
            }
        }
    }

    static class LogEntryTypeComparator
    implements Comparator<LogEntryType> {
        LogEntryTypeComparator() {
        }

        @Override
        public int compare(LogEntryType o1, LogEntryType o2) {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            Byte t1 = o1.getTypeNum();
            Byte t2 = o2.getTypeNum();
            return t1.compareTo(t2);
        }
    }

    static class EntryInfo {
        public int count = 0;
        public int provisionalCount = 0;
        public long totalBytes = 0L;
        public int headerBytes = 0;
        public int minBytes = 0;
        public int maxBytes = 0;

        EntryInfo() {
        }
    }

    class CheckpointInfoCSVFormatter
    extends CheckpointInfoTextFormatter {
        CheckpointInfoCSVFormatter() {
        }

        @Override
        String format(String value) {
            return value + ",";
        }

        @Override
        String format(int value) {
            return value + ",";
        }

        @Override
        String format(long value) {
            return value + ",";
        }
    }

    class CheckpointInfoTextFormatter {
        private NumberFormat form;

        CheckpointInfoTextFormatter() {
        }

        CheckpointInfoTextFormatter(NumberFormat form) {
            this.form = form;
        }

        String format(String value) {
            return StatsFileReader.this.pad(value);
        }

        String format(int value) {
            return StatsFileReader.this.pad(this.form.format(value));
        }

        String format(long value) {
            return StatsFileReader.this.pad(this.form.format(value));
        }
    }
}

