/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.node;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.rep.NodeType;
import com.sleepycat.je.rep.UnknownMasterException;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.node.DurabilityQuorum;
import com.sleepycat.je.rep.impl.node.Feeder;
import com.sleepycat.je.rep.impl.node.FeederManagerStatDefinition;
import com.sleepycat.je.rep.impl.node.LocalCBVLSNUpdater;
import com.sleepycat.je.rep.impl.node.MasterTransfer;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.stream.MasterStatus;
import com.sleepycat.je.rep.txn.MasterTxn;
import com.sleepycat.je.rep.utilint.IntRunningTotalStat;
import com.sleepycat.je.rep.utilint.RepUtils;
import com.sleepycat.je.rep.utilint.SizeAwaitMap;
import com.sleepycat.je.utilint.AtomicLongMapStat;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.LongAvgRateMapStat;
import com.sleepycat.je.utilint.LongDiffMapStat;
import com.sleepycat.je.utilint.LongMaxZeroStat;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.StringStat;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import com.sleepycat.je.utilint.VLSN;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public final class FeederManager {
    private final RepNode repNode;
    private final BlockingQueue<DataChannel> channelQueue = new LinkedBlockingQueue<DataChannel>();
    private final Set<Feeder> nascentFeeders = Collections.synchronizedSet(new HashSet());
    private final SizeAwaitMap<String, Feeder> activeFeeders;
    private final AtomicInteger ackFeeders = new AtomicInteger(0);
    private final AtomicInteger arbiterFeeders = new AtomicInteger(0);
    private String arbiterFeederName;
    private int testDelayMs = 0;
    AtomicBoolean shutdown = new AtomicBoolean(false);
    private RuntimeException repNodeShutdownException;
    private final DTVLSNFlusher dtvlsnFlusher;
    private final Logger logger;
    private final StatGroup stats;
    private final IntStat nFeedersCreated;
    private final IntStat nFeedersShutdown;
    private final LongDiffMapStat replicaDelayMap;
    private final AtomicLongMapStat replicaLastCommitTimestampMap;
    private final AtomicLongMapStat replicaLastCommitVLSNMap;
    private final LongDiffMapStat replicaVLSNLagMap;
    private final LongAvgRateMapStat replicaVLSNRateMap;
    private final LongMaxZeroStat nMaxReplicaLag;
    private final StringStat nMaxReplicaLagName;
    public final long pollTimeoutMs;
    public static final String FEEDER_SERVICE = "Feeder";
    private static final long MOVING_AVG_PERIOD_MILLIS = 10000L;
    private static volatile TestHook<NameIdPair> delayCBVLSNUpdateHook;
    private static TransactionConfig NULL_TXN_CONFIG;

    FeederManager(RepNode repNode) {
        this.repNode = repNode;
        this.activeFeeders = new SizeAwaitMap(repNode.getRepImpl(), new MatchElectableFeeders());
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.stats = new StatGroup("FeederManager", "A feeder is a replication stream connection between a master and replica nodes.");
        this.nFeedersCreated = new IntRunningTotalStat(this.stats, FeederManagerStatDefinition.N_FEEDERS_CREATED);
        this.nFeedersShutdown = new IntRunningTotalStat(this.stats, FeederManagerStatDefinition.N_FEEDERS_SHUTDOWN);
        this.nMaxReplicaLag = new LongMaxZeroStat(this.stats, FeederManagerStatDefinition.N_MAX_REPLICA_LAG);
        this.nMaxReplicaLagName = new StringStat(this.stats, FeederManagerStatDefinition.N_MAX_REPLICA_LAG_NAME);
        long validityMillis = 2 * repNode.getHeartbeatInterval();
        this.replicaDelayMap = new LongDiffMapStat(this.stats, FeederManagerStatDefinition.REPLICA_DELAY_MAP, validityMillis);
        this.replicaLastCommitTimestampMap = new AtomicLongMapStat(this.stats, FeederManagerStatDefinition.REPLICA_LAST_COMMIT_TIMESTAMP_MAP);
        this.replicaLastCommitVLSNMap = new AtomicLongMapStat(this.stats, FeederManagerStatDefinition.REPLICA_LAST_COMMIT_VLSN_MAP);
        this.replicaVLSNLagMap = new LongDiffMapStat(this.stats, FeederManagerStatDefinition.REPLICA_VLSN_LAG_MAP, validityMillis);
        this.replicaVLSNRateMap = new LongAvgRateMapStat(this.stats, FeederManagerStatDefinition.REPLICA_VLSN_RATE_MAP, 10000L, TimeUnit.MINUTES);
        this.pollTimeoutMs = repNode.getConfigManager().getDuration(RepParams.FEEDER_MANAGER_POLL_TIMEOUT);
        this.dtvlsnFlusher = new DTVLSNFlusher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatGroup getFeederManagerStats(StatsConfig config) {
        StatGroup statGroup = this.stats;
        synchronized (statGroup) {
            return this.stats.cloneGroup(config.getClear());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatGroup getProtocolStats(StatsConfig config) {
        StatGroup protocolStats = new StatGroup("BinaryProtocol", "Network traffic due to the replication stream.");
        SizeAwaitMap<String, Feeder> sizeAwaitMap = this.activeFeeders;
        synchronized (sizeAwaitMap) {
            for (Feeder feeder : this.activeFeeders.values()) {
                protocolStats.addAll(feeder.getProtocolStats(config));
            }
        }
        return protocolStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStats() {
        Object object = this.stats;
        synchronized (object) {
            this.stats.clear();
        }
        object = this.activeFeeders;
        synchronized (object) {
            for (Feeder feeder : this.activeFeeders.values()) {
                feeder.resetStats();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incStats(StatGroup feederStats) {
        StatGroup statGroup = this.stats;
        synchronized (statGroup) {
            this.stats.addAll(feederStats);
        }
    }

    public int getTestDelayMs() {
        return this.testDelayMs;
    }

    public void setTestDelayMs(int testDelayMs) {
        this.testDelayMs = testDelayMs;
    }

    RepNode repNode() {
        return this.repNode;
    }

    public Feeder getFeeder(String nodeName) {
        return this.activeFeeders.get(nodeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Feeder getArbiterFeeder() {
        SizeAwaitMap<String, Feeder> sizeAwaitMap = this.activeFeeders;
        synchronized (sizeAwaitMap) {
            return this.activeFeeders.get(this.arbiterFeederName);
        }
    }

    public Feeder putFeeder(String nodeName, Feeder feeder) {
        this.ackFeeders.incrementAndGet();
        return this.activeFeeders.put(nodeName, feeder);
    }

    public LongMaxZeroStat getnMaxReplicaLag() {
        return this.nMaxReplicaLag;
    }

    public StringStat getnMaxReplicaLagName() {
        return this.nMaxReplicaLagName;
    }

    LongDiffMapStat getReplicaDelayMap() {
        return this.replicaDelayMap;
    }

    AtomicLongMapStat getReplicaLastCommitTimestampMap() {
        return this.replicaLastCommitTimestampMap;
    }

    AtomicLongMapStat getReplicaLastCommitVLSNMap() {
        return this.replicaLastCommitVLSNMap;
    }

    LongDiffMapStat getReplicaVLSNLagMap() {
        return this.replicaVLSNLagMap;
    }

    LongAvgRateMapStat getReplicaVLSNRateMap() {
        return this.replicaVLSNRateMap;
    }

    void setRepNodeShutdownException(RuntimeException rNSE) {
        this.repNodeShutdownException = rNSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MinFeederVLSNInfo getMinFeederVLSN() {
        VLSN vlsn;
        VLSN min2 = VLSN.NULL_VLSN;
        String nodeName = null;
        Object object = this.nascentFeeders;
        synchronized (object) {
            for (Feeder f : this.nascentFeeders) {
                vlsn = f.getFeederVLSN();
                if (vlsn.isNull() || !min2.isNull() && vlsn.compareTo(min2) >= 0) continue;
                min2 = vlsn;
                nodeName = f.getReplicaNameIdPair().getName();
            }
        }
        object = this.activeFeeders;
        synchronized (object) {
            for (Feeder f : this.activeFeeders.values()) {
                vlsn = f.getFeederVLSN();
                if (vlsn.isNull() || !min2.isNull() && vlsn.compareTo(min2) >= 0) continue;
                min2 = vlsn;
                nodeName = f.getReplicaNameIdPair().getName();
            }
        }
        return new MinFeederVLSNInfo(min2, nodeName);
    }

    public int activeReplicaCount() {
        return this.activeFeeders.size();
    }

    public int activeAckReplicaCount() {
        return this.ackFeeders.get();
    }

    public int activeAckArbiterCount() {
        return this.arbiterFeeders.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> activeReplicas() {
        SizeAwaitMap<String, Feeder> sizeAwaitMap = this.activeFeeders;
        synchronized (sizeAwaitMap) {
            return new HashSet<String>(this.activeFeeders.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> activeAckReplicas(boolean includeArbiters) {
        HashSet<String> nodeNames = new HashSet<String>();
        SizeAwaitMap<String, Feeder> sizeAwaitMap = this.activeFeeders;
        synchronized (sizeAwaitMap) {
            for (Map.Entry<String, Feeder> entry : this.activeFeeders.entrySet()) {
                Feeder feeder = entry.getValue();
                RepNodeImpl replica = feeder.getReplicaNode();
                if (!replica.getType().isElectable() || replica.getType().isArbiter() && (!includeArbiters || !feeder.getRepNode().getArbiter().isActive())) continue;
                nodeNames.add(entry.getKey());
            }
        }
        return nodeNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Feeder> activeReplicasMap() {
        SizeAwaitMap<String, Feeder> sizeAwaitMap = this.activeFeeders;
        synchronized (sizeAwaitMap) {
            return new HashMap<String, Feeder>(this.activeFeeders);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activateFeeder(Feeder feeder) {
        Set<Feeder> set = this.nascentFeeders;
        synchronized (set) {
            SizeAwaitMap<String, Feeder> sizeAwaitMap = this.activeFeeders;
            synchronized (sizeAwaitMap) {
                boolean removed = this.nascentFeeders.remove(feeder);
                if (feeder.isShutdown()) {
                    return;
                }
                assert (removed);
                String replicaName = feeder.getReplicaNameIdPair().getName();
                assert (!feeder.getReplicaNameIdPair().equals(NameIdPair.NULL));
                Feeder dup = this.activeFeeders.get(replicaName);
                if (dup != null && !dup.isShutdown()) {
                    throw EnvironmentFailureException.unexpectedState(this.repNode.getRepImpl(), feeder.getReplicaNameIdPair() + " is present in both nascent and " + "active feeder sets");
                }
                this.activeFeeders.put(replicaName, feeder);
                if (feeder.getReplicaNode().getType().isArbiter()) {
                    assert (this.arbiterFeeders.get() == 0);
                    this.arbiterFeeders.incrementAndGet();
                    this.arbiterFeederName = replicaName;
                } else if (feeder.getReplicaNode().getType().isElectable()) {
                    this.ackFeeders.incrementAndGet();
                }
                MasterTransfer xfr = this.repNode.getActiveTransfer();
                if (xfr != null) {
                    xfr.addFeeder(feeder);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFeeder(Feeder feeder) {
        assert (feeder.isShutdown());
        String replicaName = feeder.getReplicaNameIdPair().getName();
        Set<Feeder> set = this.nascentFeeders;
        synchronized (set) {
            SizeAwaitMap<String, Feeder> sizeAwaitMap = this.activeFeeders;
            synchronized (sizeAwaitMap) {
                this.nascentFeeders.remove(feeder);
                if (this.activeFeeders.remove(replicaName) != null) {
                    if (this.arbiterFeederName != null && this.arbiterFeederName.equals(replicaName)) {
                        this.arbiterFeeders.decrementAndGet();
                        this.arbiterFeederName = null;
                    } else if (feeder.getReplicaNode().getType().isElectable()) {
                        this.ackFeeders.decrementAndGet();
                    }
                }
            }
        }
        RepNodeImpl node = feeder.getReplicaNode();
        if (node != null && node.getType().hasTransientId()) {
            this.repNode.removeTransientNode(node);
        }
    }

    void shutdownQueue() {
        if (!this.repNode.isShutdown()) {
            throw EnvironmentFailureException.unexpectedState("Rep node is still active");
        }
        this.channelQueue.clear();
        this.channelQueue.add(RepUtils.CHANNEL_EOF_MARKER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void runFeeders() throws DatabaseException {
        if (this.shutdown.get()) {
            throw EnvironmentFailureException.unexpectedState("Feeder manager was shutdown");
        }
        feederShutdownException /* !! */  = null;
        LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Feeder manager accepting requests.");
        updater = new LocalCBVLSNUpdater(this.repNode.getNameIdPair(), this.repNode.getNodeType(), this.repNode);
        tracker = this.repNode.getCBVLSNTracker();
        try {
            updater.updateForMaster(tracker);
            this.repNode.getServiceDispatcher().register("Feeder", this.channelQueue);
            this.repNode.getReadyLatch().countDown();
lbl11:
            // 6 sources

            while (true) {
                feederReplicaChannel = this.channelQueue.poll(this.pollTimeoutMs, TimeUnit.MILLISECONDS);
                if (feederReplicaChannel != RepUtils.CHANNEL_EOF_MARKER) ** GOTO lbl-1000
                LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Feeder manager soft shutdown.");
                this.repNode.resetReadyLatch(feederShutdownException /* !! */ );
                this.repNode.getServiceDispatcher().cancel("Feeder");
                this.shutdownFeeders(feederShutdownException /* !! */ );
                ** GOTO lbl45
                break;
            }
        }
        catch (MasterStatus.MasterSyncException e) {
            LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Master change: " + e.getMessage());
            feederShutdownException /* !! */  = new UnknownMasterException("Node " + this.repNode.getRepImpl().getName() + " is not a master anymore");
            this.repNode.resetReadyLatch(feederShutdownException /* !! */ );
            this.repNode.getServiceDispatcher().cancel("Feeder");
            this.shutdownFeeders(feederShutdownException /* !! */ );
            LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Feeder manager exited. CurrentTxnEnd VLSN: " + this.repNode.getCurrentTxnEndVLSN());
            return;
        }
        catch (InterruptedException e) {
            try {
                if (this.repNodeShutdownException != null) {
                    LoggerUtils.warning(this.logger, this.repNode.getRepImpl(), "Feeder manager unexpected interrupt");
                    throw this.repNodeShutdownException;
                }
                if (this.repNode.isShutdown()) {
                    LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Feeder manager interrupted for shutdown");
                    this.repNode.resetReadyLatch(feederShutdownException /* !! */ );
                    this.repNode.getServiceDispatcher().cancel("Feeder");
                    this.shutdownFeeders(feederShutdownException /* !! */ );
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var7_11) {
                this.repNode.resetReadyLatch(feederShutdownException /* !! */ );
                this.repNode.getServiceDispatcher().cancel("Feeder");
                this.shutdownFeeders(feederShutdownException /* !! */ );
                LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Feeder manager exited. CurrentTxnEnd VLSN: " + this.repNode.getCurrentTxnEndVLSN());
                throw var7_11;
            }
lbl45:
            // 1 sources

            LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Feeder manager exited. CurrentTxnEnd VLSN: " + this.repNode.getCurrentTxnEndVLSN());
            return;
lbl-1000:
            // 1 sources

            {
                this.repNode.getMasterStatus().assertSync();
                if (feederReplicaChannel != null) ** GOTO lbl65
                if (!this.repNode.isShutdownOrInvalid()) ** GOTO lbl-1000
                LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Feeder manager forced shutdown.");
                this.repNode.resetReadyLatch(feederShutdownException /* !! */ );
                this.repNode.getServiceDispatcher().cancel("Feeder");
                this.shutdownFeeders(feederShutdownException /* !! */ );
            }
            LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Feeder manager exited. CurrentTxnEnd VLSN: " + this.repNode.getCurrentTxnEndVLSN());
            return;
lbl-1000:
            // 1 sources

            {
                try {
                    if (!FeederManager.$assertionsDisabled && !TestHookExecute.doHookIfSet(FeederManager.delayCBVLSNUpdateHook, this.repNode.getNameIdPair())) {
                        throw new AssertionError();
                    }
                }
                catch (IllegalStateException e) {
                    ** GOTO lbl11
                }
                updater.updateForMaster(tracker);
                this.dtvlsnFlusher.flush();
                ** GOTO lbl11
lbl65:
                // 1 sources

                this.nFeedersCreated.increment();
                try {
                    feeder = new Feeder(this, feederReplicaChannel);
                    this.nascentFeeders.add(feeder);
                    feeder.startFeederThreads();
                }
                catch (IOException e) {
                    LoggerUtils.fine(this.logger, this.repNode.getRepImpl(), "Feeder I/O exception: " + e.getMessage());
                    try {
                        feederReplicaChannel.close();
                        ** GOTO lbl11
                    }
                    catch (IOException e1) {
                        LoggerUtils.fine(this.logger, this.repNode.getRepImpl(), "Exception during cleanup." + e.getMessage());
                    }
                }
                ** continue;
            }
            LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Feeder manager exited. CurrentTxnEnd VLSN: " + this.repNode.getCurrentTxnEndVLSN());
            return;
lbl-1000:
            // 1 sources

            {
                feederShutdownException /* !! */  = e;
                LoggerUtils.warning(this.logger, this.repNode.getRepImpl(), "Feeder manager unexpected interrupt");
                this.repNode.resetReadyLatch(feederShutdownException /* !! */ );
                this.repNode.getServiceDispatcher().cancel("Feeder");
                this.shutdownFeeders(feederShutdownException /* !! */ );
            }
            LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Feeder manager exited. CurrentTxnEnd VLSN: " + this.repNode.getCurrentTxnEndVLSN());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownFeeders(Exception feederShutdownException) {
        boolean changed = this.shutdown.compareAndSet(false, true);
        if (!changed) {
            return;
        }
        try {
            HashSet<Feeder> feederSet;
            Set<Feeder> set = this.nascentFeeders;
            synchronized (set) {
                SizeAwaitMap<String, Feeder> sizeAwaitMap = this.activeFeeders;
                synchronized (sizeAwaitMap) {
                    feederSet = new HashSet<Feeder>(this.activeFeeders.values());
                    feederSet.addAll(this.nascentFeeders);
                }
            }
            for (Feeder feeder : feederSet) {
                this.nFeedersShutdown.increment();
                feeder.shutdown(feederShutdownException);
            }
        }
        finally {
            if (feederShutdownException == null) {
                feederShutdownException = new IllegalStateException("FeederManager shutdown");
                this.activeFeeders.clear(null);
            } else {
                this.activeFeeders.clear(feederShutdownException);
            }
            this.nascentFeeders.clear();
        }
    }

    public void shutdownFeeder(RepNodeImpl node) {
        Feeder feeder = this.activeFeeders.get(node.getName());
        if (feeder == null) {
            return;
        }
        this.nFeedersShutdown.increment();
        feeder.shutdown(null);
    }

    public boolean awaitFeederReplicaConnections(int requiredReplicaCount, long insufficientReplicasTimeout) throws InterruptedException {
        return this.activeFeeders.sizeAwait(requiredReplicaCount, insufficientReplicasTimeout, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpState(boolean acksOnly) {
        StringBuilder sb = new StringBuilder();
        SizeAwaitMap<String, Feeder> sizeAwaitMap = this.activeFeeders;
        synchronized (sizeAwaitMap) {
            Set<Map.Entry<String, Feeder>> feeds = this.activeFeeders.entrySet();
            if (feeds.size() == 0) {
                sb.append("No feeders.");
            } else {
                sb.append("Current feeds:");
                for (Map.Entry<String, Feeder> feedEntry : feeds) {
                    NodeType nodeType;
                    Feeder feeder = feedEntry.getValue();
                    if (acksOnly && ((nodeType = feeder.getReplicaNode().getType()).isSecondary() || nodeType.isExternal())) continue;
                    sb.append("\n ").append(feedEntry.getKey()).append(": ");
                    sb.append(feeder.dumpState());
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumCurrentAckFeeders(VLSN commitVLSN) {
        DurabilityQuorum durabilityQuorum = this.repNode.getDurabilityQuorum();
        int count = 0;
        SizeAwaitMap<String, Feeder> sizeAwaitMap = this.activeFeeders;
        synchronized (sizeAwaitMap) {
            for (Feeder feeder : this.activeFeeders.values()) {
                if (commitVLSN.compareTo(feeder.getReplicaTxnEndVLSN()) > 0 || !durabilityQuorum.replicaAcksQualify(feeder.getReplicaNode())) continue;
                ++count;
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDTVLSN(long heartbeatVLSN) {
        long currDTVLSN = this.repNode.getDTVLSN();
        if (heartbeatVLSN <= currDTVLSN) {
            return;
        }
        DurabilityQuorum durabilityQuorum = this.repNode.getDurabilityQuorum();
        int durableAckCount = durabilityQuorum.getCurrentRequiredAckCount(Durability.ReplicaAckPolicy.SIMPLE_MAJORITY);
        long min2 = Long.MAX_VALUE;
        SizeAwaitMap<String, Feeder> sizeAwaitMap = this.activeFeeders;
        synchronized (sizeAwaitMap) {
            int ackCount = 0;
            for (Feeder feeder : this.activeFeeders.values()) {
                long replicaTxnVLSN;
                if (!durabilityQuorum.replicaAcksQualify(feeder.getReplicaNode()) || (replicaTxnVLSN = feeder.getReplicaTxnEndVLSN().getSequence()) <= currDTVLSN) continue;
                if (replicaTxnVLSN < min2) {
                    min2 = replicaTxnVLSN;
                }
                if (++ackCount < durableAckCount) continue;
                this.repNode.updateDTVLSN(min2);
                return;
            }
            return;
        }
    }

    public static void setDelayCBVLSNUpdateHook(TestHook<NameIdPair> hook) {
        delayCBVLSNUpdateHook = hook;
    }

    static {
        NULL_TXN_CONFIG = new TransactionConfig();
        NULL_TXN_CONFIG.setDurability(new Durability(Durability.SyncPolicy.WRITE_NO_SYNC, Durability.SyncPolicy.WRITE_NO_SYNC, Durability.ReplicaAckPolicy.NONE));
    }

    private class DTVLSNFlusher {
        final int targetStableTicks;
        private int stableTicks = 0;
        private long stableDTVLSN = -1L;
        private long persistedDTVLSN = -1L;
        private long nullTxnVLSN = -1L;

        public DTVLSNFlusher() {
            int heartbeatMs = FeederManager.this.repNode.getConfigManager().getInt(RepParams.HEARTBEAT_INTERVAL);
            this.targetStableTicks = (int)Math.max(1L, (long)(2 * heartbeatMs) / FeederManager.this.pollTimeoutMs);
        }

        void flush() {
            long dtvlsn = FeederManager.this.repNode.getDTVLSN();
            if (dtvlsn == this.nullTxnVLSN) {
                return;
            }
            if (dtvlsn > this.stableDTVLSN) {
                this.stableTicks = 0;
                this.stableDTVLSN = dtvlsn;
                return;
            }
            if (dtvlsn < this.stableDTVLSN) {
                throw new IllegalStateException("The DTVLSN sequence cannot decreasecurrent DTVLSN:" + dtvlsn + " previous DTVLSN:" + this.stableDTVLSN);
            }
            if (++this.stableTicks <= this.targetStableTicks) {
                return;
            }
            this.stableTicks = 0;
            if (this.stableDTVLSN > this.persistedDTVLSN) {
                if (FeederManager.this.repNode.getActiveTransfer() != null) {
                    LoggerUtils.info(FeederManager.this.logger, FeederManager.this.repNode.getRepImpl(), "Skipped null txn updating DTVLSN: " + dtvlsn + " Master transfer in progress");
                    return;
                }
                RepImpl repImpl = FeederManager.this.repNode.getRepImpl();
                MasterTxn nullTxn = MasterTxn.createNullTxn(repImpl, NULL_TXN_CONFIG, repImpl.getNameIdPair());
                nullTxn.setTxnTimeout(1L);
                try {
                    nullTxn.commit();
                    LoggerUtils.fine(FeederManager.this.logger, FeederManager.this.repNode.getRepImpl(), "Persist DTVLSN: " + dtvlsn + " at VLSN: " + nullTxn.getCommitVLSN() + " via null transaction:" + nullTxn.getId());
                    this.nullTxnVLSN = nullTxn.getCommitVLSN().getSequence();
                    this.stableDTVLSN = this.persistedDTVLSN = dtvlsn;
                }
                catch (Exception e) {
                    nullTxn.abort();
                    LoggerUtils.warning(FeederManager.this.logger, FeederManager.this.repNode.getRepImpl(), "Failed to write null txn updating DTVLSN; " + e.getMessage());
                }
            }
        }
    }

    public static class MinFeederVLSNInfo {
        public final VLSN vlsn;
        public final String nodeName;

        MinFeederVLSNInfo(VLSN vlsn, String nodeName) {
            this.vlsn = vlsn;
            this.nodeName = nodeName;
        }
    }

    private class MatchElectableFeeders
    implements SizeAwaitMap.Predicate<Feeder> {
        private MatchElectableFeeders() {
        }

        @Override
        public boolean match(Feeder value) {
            RepNodeImpl replica = value.getReplicaNode();
            return replica != null && FeederManager.this.repNode.getDurabilityQuorum().replicaAcksQualify(replica);
        }
    }
}

