/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.node;

import com.sleepycat.je.ThreadInterruptedException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.MasterTransferFailureException;
import com.sleepycat.je.rep.elections.Elections;
import com.sleepycat.je.rep.elections.Learner;
import com.sleepycat.je.rep.elections.MasterValue;
import com.sleepycat.je.rep.elections.Proposer;
import com.sleepycat.je.rep.elections.TimebasedProposalGenerator;
import com.sleepycat.je.rep.impl.RepGroupImpl;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.impl.node.Feeder;
import com.sleepycat.je.rep.impl.node.FeederManager;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.utilint.RepUtils;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.VLSN;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MasterTransfer {
    private final Set<String> replicas;
    private final long startTimeMs;
    private final long timeout;
    private final long deadlineTimeMs;
    private final RepNode repNode;
    private final Map<String, VLSN> readyReplicas;
    private volatile CountDownLatch blocker;
    private volatile boolean done;
    private RepUtils.ExceptionAwareBlockingQueue<VLSNProgress> eventQueue;
    private final Logger logger = LoggerUtils.getLogger(this.getClass());

    MasterTransfer(Set<String> replicas, long timeout, RepNode repNode) {
        this.replicas = replicas;
        this.timeout = timeout;
        this.startTimeMs = System.currentTimeMillis();
        this.deadlineTimeMs = this.startTimeMs + timeout;
        this.repNode = repNode;
        LoggerUtils.info(this.logger, repNode.getRepImpl(), "Start Master Transfer for " + timeout + " msec, targeting: " + Arrays.toString(replicas.toArray()));
        this.readyReplicas = new HashMap<String, VLSN>(replicas.size());
        this.eventQueue = new RepUtils.ExceptionAwareBlockingQueue<VLSNProgress>(repNode.getRepImpl(), new VLSNProgress(null, null));
    }

    public synchronized boolean abort(Exception e) {
        assert (e != null);
        if (this.done) {
            return false;
        }
        RepUtils.ExceptionAwareBlockingQueue<VLSNProgress> queue = this.getQueue();
        if (queue != null) {
            queue.releasePoll(e);
        }
        return true;
    }

    synchronized void noteProgress(VLSNProgress p) {
        RepUtils.ExceptionAwareBlockingQueue<VLSNProgress> queue = this.getQueue();
        if (queue != null) {
            queue.add(p);
        }
    }

    void giveUp(String replicaNodeName) {
        this.noteProgress(VLSNProgress.makeFeederDeathEvent(replicaNodeName));
    }

    private synchronized RepUtils.ExceptionAwareBlockingQueue<VLSNProgress> getQueue() {
        return this.eventQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String transfer() {
        try {
            String result = this.chooseReplica();
            if (result == null) {
                throw new MasterTransferFailureException(this.getTimeoutMsg());
            }
            this.done = true;
            Object object = this;
            synchronized (object) {
                this.eventQueue = null;
            }
            this.annouceWinner(result);
            object = result;
            return object;
        }
        catch (MasterTransferFailureException e) {
            LoggerUtils.warning(this.logger, this.repNode.getRepImpl(), "Master Transfer operation failed: " + e);
            throw e;
        }
        catch (InterruptedException ie) {
            throw new ThreadInterruptedException((EnvironmentImpl)this.repNode.getRepImpl(), (Throwable)ie);
        }
        finally {
            this.eventQueue = null;
            if (!this.done && this.blocker != null) {
                this.blocker.countDown();
            }
        }
    }

    private String chooseReplica() throws InterruptedException {
        RepUtils.ExceptionAwareBlockingQueue<VLSNProgress> queue = this.getQueue();
        if (queue == null) {
            return null;
        }
        FeederManager feederManager = this.repNode.feederManager();
        Map<String, Feeder> activeReplicas = feederManager.activeReplicasMap();
        for (String nodeName : this.replicas) {
            Feeder feeder = activeReplicas.get(nodeName);
            if (feeder == null) continue;
            feeder.setMasterTransfer(this);
        }
        String result = null;
        do {
            long pollTimeout;
            VLSNProgress event;
            if ((event = queue.pollOrException(pollTimeout = this.deadlineTimeMs - System.currentTimeMillis(), TimeUnit.MILLISECONDS)) == null) {
                return null;
            }
            VLSN endVLSN = this.repNode.getCurrentTxnEndVLSN();
            Level level = Level.INFO;
            if (event.isFeederDeathEvent()) {
                this.readyReplicas.remove(event.replicaNodeName);
                if (this.blocker != null && this.readyReplicas.isEmpty()) {
                    this.blocker.countDown();
                    this.blocker = null;
                }
            } else if (this.blocker == null) {
                assert (this.readyReplicas.isEmpty());
                this.readyReplicas.put(event.replicaNodeName, event.vlsn);
                this.blocker = new CountDownLatch(1);
                this.repNode.getRepImpl().blockTxnCompletion(this.blocker);
                if (event.getVLSN().compareTo(endVLSN) >= 0) {
                    result = event.replicaNodeName;
                }
            } else if (event.getVLSN().compareTo(endVLSN) >= 0) {
                result = event.replicaNodeName;
            } else {
                this.readyReplicas.put(event.replicaNodeName, event.vlsn);
                level = Level.FINE;
            }
            LoggerUtils.logMsg(this.logger, this.repNode.getRepImpl(), level, "Master Transfer progress: " + event.replicaNodeName + ", " + event.vlsn + ", phase: " + (this.blocker == null ? 1 : 2) + ", endVLSN: " + endVLSN);
        } while (result == null);
        return result;
    }

    private void annouceWinner(String nodeName) {
        RepGroupImpl group = this.repNode.getGroup();
        RepNodeImpl node = group.getNode(nodeName);
        MasterValue newMaster = new MasterValue(node.getSocketAddress().getHostName(), node.getSocketAddress().getPort(), node.getNameIdPair());
        Proposer.Proposal proposal = new TimebasedProposalGenerator().nextProposal();
        Elections elections = this.repNode.getElections();
        elections.getLearner();
        Learner.informLearners(group.getAllLearnerSockets(), new Proposer.WinningProposal(proposal, newMaster, null), elections.getProtocol(), elections.getThreadPool(), elections.getLogger(), this.repNode.getRepImpl(), null);
    }

    void addFeeder(Feeder f) {
        String name2 = f.getReplicaNameIdPair().getName();
        if (this.replicas.contains(name2)) {
            LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Add node " + name2 + " to existing Master Transfer");
            f.setMasterTransfer(this);
        }
    }

    long getStartTime() {
        return this.startTimeMs;
    }

    private String getTimeoutMsg() {
        return "Timed out: started at " + new Date(this.startTimeMs) + " for " + this.timeout + " milliseconds\n" + "master's VLSN: " + this.repNode.getCurrentTxnEndVLSN() + this.repNode.dumpAckFeederState();
    }

    static class VLSNProgress {
        final VLSN vlsn;
        final String replicaNodeName;

        VLSNProgress(VLSN vlsn, String replicaNodeName) {
            this.vlsn = vlsn;
            this.replicaNodeName = replicaNodeName;
        }

        static VLSNProgress makeFeederDeathEvent(String nodeName) {
            return new VLSNProgress(null, nodeName);
        }

        VLSN getVLSN() {
            assert (this.vlsn != null);
            return this.vlsn;
        }

        boolean isFeederDeathEvent() {
            return this.vlsn == null;
        }
    }
}

