/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.node;

import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class NameIdPair
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private int id;
    public static final int NULL_NODE_ID = -1;
    public static final int NOCHECK_NODE_ID = Integer.MIN_VALUE;
    public static final NameIdPair NULL = new ReadOnlyNameIdPair("NullNode", -1);
    public static final NameIdPair NOCHECK = new ReadOnlyNameIdPair("NoCheckNode", Integer.MIN_VALUE);

    public NameIdPair(String name2, int id) {
        if (name2 == null) {
            throw EnvironmentFailureException.unexpectedState("name argument was null");
        }
        this.name = name2;
        this.id = id;
    }

    public NameIdPair(String name2) {
        this(name2, NULL.getId());
    }

    public static NameIdPair deserialize(ByteBuffer buffer, BinaryProtocol protocol) {
        return new NameIdPair(protocol.getString(buffer), LogUtils.readInt(buffer));
    }

    public static NameIdPair deserialize(TupleInput buffer) {
        return new NameIdPair(buffer.readString(), buffer.readInt());
    }

    public void serialize(ByteBuffer buffer, BinaryProtocol protocol) {
        protocol.putString(this.name, buffer);
        LogUtils.writeInt(buffer, this.id);
    }

    public void serialize(TupleOutput buffer) {
        buffer.writeString(this.name);
        buffer.writeInt(this.id);
    }

    public int serializedSize(BinaryProtocol protocol) {
        return protocol.stringSize(this.name) + 4;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + "(" + this.id + ")";
    }

    public int getId() {
        return this.id;
    }

    public boolean hasNullId() {
        return this.id == -1;
    }

    public void setId(int id) {
        this.setId(id, true);
    }

    public void setId(int id, boolean checkId) {
        if (checkId && id != this.id && !this.hasNullId()) {
            throw EnvironmentFailureException.unexpectedState("Id was already not null: " + this.id);
        }
        this.id = id;
    }

    public void revertToNull() {
        this.id = -1;
    }

    public void update(NameIdPair other) {
        if (!this.name.equals(other.getName())) {
            throw EnvironmentFailureException.unexpectedState("Pair name mismatch: " + this.name + " <> " + other.getName());
        }
        this.setId(other.getId());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NameIdPair)) {
            return false;
        }
        NameIdPair other = (NameIdPair)obj;
        if (this.id != other.id) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            throw EnvironmentFailureException.unexpectedState("Ids: " + this.id + " were equal." + " But names: " + this.name + ", " + other.name + " weren't!");
        }
        return true;
    }

    private static class ReadOnlyNameIdPair
    extends NameIdPair {
        private static final long serialVersionUID = 1L;

        public ReadOnlyNameIdPair(String name2, int id) {
            super(name2, id);
        }

        @Override
        public void setId(int id) {
            throw EnvironmentFailureException.unexpectedState("Read only NameIdPair");
        }
    }
}

