/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.node;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.impl.node.Replay;
import com.sleepycat.je.rep.impl.node.Replica;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.rep.utilint.BinaryProtocolStatDefinition;
import com.sleepycat.je.utilint.StatGroup;

public class ReplicaFactory {
    private static ReplicaType type = ReplicaType.DEFAULT;
    private static long statsInterval = 0L;

    public static void setReplicaType(ReplicaType t2) {
        type = t2;
    }

    public static void setStatsInterval(long interval) {
        statsInterval = interval;
    }

    public static Replica create(RepNode repNode, Replay replay) {
        switch (type) {
            case DEFAULT: {
                return new Replica(repNode, replay);
            }
            case NULL_REPLICA: {
                return new Replica(repNode, replay){

                    @Override
                    protected void doRunReplicaLoopInternalWork() throws Exception {
                        long ctime = System.currentTimeMillis();
                        long opCount = 0L;
                        while (true) {
                            BinaryProtocol.Message message = this.getProtocol().read(this.getReplicaFeederChannel());
                            if (statsInterval <= 0L || ++opCount % statsInterval != 0L) continue;
                            StatGroup stats = this.getProtocol().getStats(StatsConfig.DEFAULT);
                            long bytesRead = stats.getLong(BinaryProtocolStatDefinition.N_BYTES_READ);
                            long messagesRead = stats.getLong(BinaryProtocolStatDefinition.N_MESSAGES_READ);
                            long elapsedTime = System.currentTimeMillis() - ctime;
                            long bytesPerMilliSecond = bytesRead / elapsedTime;
                            System.out.println(" Bytes Read: " + bytesRead + " Messages Read: " + messagesRead + " BytesPerMSec: " + bytesPerMilliSecond + " MS: " + elapsedTime);
                            ctime = System.currentTimeMillis();
                        }
                    }
                };
            }
        }
        throw EnvironmentFailureException.unexpectedState("unknown type passed to makeReplica: " + (Object)((Object)type));
    }

    public static enum ReplicaType {
        DEFAULT,
        NULL_REPLICA;

    }
}

