/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.util;

import com.sleepycat.je.Durability;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.rep.RepInternal;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.ReplicationConfig;
import com.sleepycat.je.rep.impl.RepParams;
import java.io.File;

public class DbEnableReplication {
    private File envHome;
    private String groupName;
    private String nodeName;
    private String nodeHostPort;
    private static final String usageString = "usage: java -cp je.jar com.sleepycat.je.rep.util.DbEnableReplication\n -h <dir>                              # environment home directory\n -groupName <group name>               # replication group name\n -nodeName <node name>                 # replicated node name\n -nodeHostPort <host name:port number> # host name or IP address\n                                          and port number to use\n                                          for this node\n";

    public static void main(String[] args) {
        DbEnableReplication converter = new DbEnableReplication();
        converter.parseArgs(args);
        try {
            converter.convert();
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
    }

    private void printUsage(String msg) {
        System.err.println(msg);
        System.err.println(usageString);
        System.exit(-1);
    }

    private void parseArgs(String[] args) {
        int argc = 0;
        int nArgs = args.length;
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = args[argc++].trim()).equals("-h")) {
                if (argc < nArgs) {
                    this.envHome = new File(args[argc++]);
                    continue;
                }
                this.printUsage("-h requires an argument");
                continue;
            }
            if (thisArg.equals("-groupName")) {
                if (argc < nArgs) {
                    this.groupName = args[argc++];
                    continue;
                }
                this.printUsage("-groupName requires an argument");
                continue;
            }
            if (thisArg.equals("-nodeName")) {
                if (argc < nArgs) {
                    this.nodeName = args[argc++];
                    continue;
                }
                this.printUsage("-nodeName requires an argument");
                continue;
            }
            if (!thisArg.equals("-nodeHostPort")) continue;
            if (argc < nArgs) {
                this.nodeHostPort = args[argc++];
                try {
                    RepParams.NODE_HOST_PORT.validateValue(this.nodeHostPort);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    this.printUsage("-nodeHostPort is illegal!");
                }
                continue;
            }
            this.printUsage("-nodeHostPort requires an argument");
        }
        if (this.envHome == null) {
            this.printUsage("-h is a required argument.");
        }
        if (this.groupName == null) {
            this.printUsage("-groupName is a required argument.");
        }
        if (this.nodeName == null) {
            this.printUsage("-nodeName is a required argument.");
        }
        if (this.nodeHostPort == null) {
            this.printUsage("-nodeHostPort is a required argument.");
        }
    }

    private DbEnableReplication() {
    }

    public DbEnableReplication(File envHome, String groupName, String nodeName, String nodeHostPort) {
        this.envHome = envHome;
        this.groupName = groupName;
        this.nodeName = nodeName;
        this.nodeHostPort = nodeHostPort;
    }

    public void convert() {
        Durability durability = new Durability(Durability.SyncPolicy.WRITE_NO_SYNC, Durability.SyncPolicy.WRITE_NO_SYNC, Durability.ReplicaAckPolicy.SIMPLE_MAJORITY);
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setAllowCreate(true);
        envConfig.setTransactional(true);
        envConfig.setDurability(durability);
        ReplicationConfig repConfig = new ReplicationConfig(this.groupName, this.nodeName, this.nodeHostPort);
        repConfig.setHelperHosts(repConfig.getNodeHostPort());
        RepInternal.setAllowConvert(repConfig, true);
        ReplicatedEnvironment repEnv = new ReplicatedEnvironment(this.envHome, repConfig, envConfig);
        repEnv.close();
    }
}

