/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.utilint.net;

import com.sleepycat.je.rep.net.InstanceParams;
import java.security.Principal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;

class SSLDNMatcher {
    private final Pattern pattern;

    SSLDNMatcher(InstanceParams params) throws IllegalArgumentException {
        this.pattern = SSLDNMatcher.compileRegex(params.getClassParams());
    }

    public boolean peerMatches(SSLSession sslSession) {
        X500Principal x500Principal;
        String name2;
        Matcher m4;
        Principal principal = null;
        try {
            principal = sslSession.getPeerPrincipal();
        }
        catch (SSLPeerUnverifiedException pue) {
            return false;
        }
        return principal != null && principal instanceof X500Principal && (m4 = this.pattern.matcher(name2 = (x500Principal = (X500Principal)principal).getName("RFC1779"))).matches();
    }

    private static Pattern compileRegex(String regex) throws IllegalArgumentException {
        try {
            return Pattern.compile(regex);
        }
        catch (PatternSyntaxException pse) {
            throw new IllegalArgumentException("pattern is invalid", pse);
        }
    }

    static void validateRegex(String regex) throws IllegalArgumentException {
        SSLDNMatcher.compileRegex(regex);
    }
}

