/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.TransactionStats;
import com.sleepycat.je.utilint.ActiveTxnArrayStat;
import com.sleepycat.je.utilint.AtomicIntStat;
import com.sleepycat.je.utilint.AtomicLongStat;
import com.sleepycat.je.utilint.BooleanStat;
import com.sleepycat.je.utilint.FloatStat;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.IntegralLongAvgStat;
import com.sleepycat.je.utilint.LongArrayStat;
import com.sleepycat.je.utilint.LongMaxStat;
import com.sleepycat.je.utilint.LongMinStat;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.Stat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StringStat;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class StatGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String groupName;
    private final String groupDescription;
    private final Map<StatDefinition, Stat<?>> stats;

    public StatGroup(String groupName, String groupDescription) {
        this(groupName, groupDescription, new HashMap());
    }

    private StatGroup(String groupName, String groupDescription, Map<StatDefinition, Stat<?>> values) {
        this.groupName = groupName;
        this.groupDescription = groupDescription;
        this.stats = Collections.synchronizedMap(values);
    }

    public Map<StatDefinition, Stat<?>> getStats() {
        return Collections.unmodifiableMap(this.stats);
    }

    void register(Stat<?> oneStat) {
        Stat<?> prev = this.stats.put(oneStat.getDefinition(), oneStat);
        assert (prev == null) : "prev = " + prev + " oneStat=" + oneStat.getDefinition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(StatGroup other) {
        for (Map.Entry<StatDefinition, Stat<?>> entry : other.stats.entrySet()) {
            Stat<?> localStat;
            StatDefinition definition = entry.getKey();
            Map<StatDefinition, Stat<?>> map = this.stats;
            synchronized (map) {
                localStat = this.stats.get(definition);
                if (localStat == null) {
                    this.stats.put(definition, entry.getValue());
                    continue;
                }
            }
            Stat<?> additionalValue = entry.getValue();
            localStat.add(additionalValue);
        }
    }

    public StatGroup computeInterval(StatGroup baseGroup) {
        HashMap intervalValues = new HashMap();
        for (Map.Entry<StatDefinition, Stat<?>> entry : this.stats.entrySet()) {
            StatDefinition definition = entry.getKey();
            Stat<?> statValue = entry.getValue();
            Stat<?> baseStat = baseGroup.stats.get(definition);
            if (baseStat == null) {
                intervalValues.put(definition, (Stat<?>)statValue.copy());
                continue;
            }
            intervalValues.put(definition, statValue.computeInterval(baseStat));
        }
        return new StatGroup(this.groupName, this.groupDescription, intervalValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<StatDefinition, Stat<?>> map = this.stats;
        synchronized (map) {
            for (Stat<?> s2 : this.stats.values()) {
                s2.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void negate() {
        Map<StatDefinition, Stat<?>> map = this.stats;
        synchronized (map) {
            for (Stat<?> s2 : this.stats.values()) {
                s2.negate();
            }
        }
    }

    public String getName() {
        return this.groupName;
    }

    public String getDescription() {
        return this.groupDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatGroup cloneGroup(boolean clear) {
        HashMap copyValues = new HashMap();
        Map<StatDefinition, Stat<?>> map = this.stats;
        synchronized (map) {
            for (Stat<?> s2 : this.stats.values()) {
                if (clear) {
                    copyValues.put(s2.getDefinition(), s2.copyAndClear());
                    continue;
                }
                copyValues.put(s2.getDefinition(), (Stat<?>)s2.copy());
            }
        }
        return new StatGroup(this.groupName, this.groupDescription, copyValues);
    }

    public Stat<?> getStat(StatDefinition definition) {
        return this.stats.get(definition);
    }

    public int getInt(StatDefinition definition) {
        int retval;
        Stat<?> s2 = this.stats.get(definition);
        if (s2 == null) {
            retval = 0;
        } else if (s2 instanceof IntStat) {
            retval = ((IntStat)s2).get();
        } else if (s2 instanceof AtomicIntStat) {
            retval = ((AtomicIntStat)s2).get();
        } else {
            assert (false) : "Internal error calling getInt with unexpected stat type: " + s2.getClass().getName();
            retval = 0;
        }
        return retval;
    }

    public LongStat getLongStat(StatDefinition definition) {
        return (LongStat)this.stats.get(definition);
    }

    public long getLong(StatDefinition definition) {
        long retval = 0L;
        Stat<?> s2 = this.stats.get(definition);
        if (s2 == null) {
            retval = 0L;
        } else if (s2 instanceof LongStat) {
            retval = ((LongStat)s2).get();
        } else if (s2 instanceof AtomicLongStat) {
            retval = ((AtomicLongStat)s2).get();
        } else if (s2 instanceof IntegralLongAvgStat) {
            retval = ((IntegralLongAvgStat)s2).get().compute();
        } else assert (false) : "Internal error calling getLong() with unknown stat type.";
        return retval;
    }

    public IntegralLongAvgStat getIntegralLongAvgStat(StatDefinition definition) {
        return (IntegralLongAvgStat)this.stats.get(definition);
    }

    public LongMinStat getLongMinStat(StatDefinition definition) {
        return (LongMinStat)this.stats.get(definition);
    }

    public LongMaxStat getLongMaxStat(StatDefinition definition) {
        return (LongMaxStat)this.stats.get(definition);
    }

    public AtomicLongStat getAtomicLongStat(StatDefinition definition) {
        return (AtomicLongStat)this.stats.get(definition);
    }

    public Long getAtomicLong(StatDefinition definition) {
        AtomicLongStat s2 = (AtomicLongStat)this.stats.get(definition);
        if (s2 == null) {
            return 0L;
        }
        return s2.get();
    }

    public TransactionStats.Active[] getActiveTxnArray(StatDefinition definition) {
        ActiveTxnArrayStat s2 = (ActiveTxnArrayStat)this.stats.get(definition);
        if (s2 == null) {
            return null;
        }
        return s2.get();
    }

    public long[] getLongArray(StatDefinition definition) {
        LongArrayStat s2 = (LongArrayStat)this.stats.get(definition);
        if (s2 == null) {
            return null;
        }
        return s2.get();
    }

    public float getFloat(StatDefinition definition) {
        FloatStat s2 = (FloatStat)this.stats.get(definition);
        if (s2 == null) {
            return 0.0f;
        }
        return s2.get().floatValue();
    }

    public boolean getBoolean(StatDefinition definition) {
        BooleanStat s2 = (BooleanStat)this.stats.get(definition);
        if (s2 == null) {
            return false;
        }
        return s2.get();
    }

    public String getString(StatDefinition definition) {
        StringStat s2 = (StringStat)this.stats.get(definition);
        if (s2 == null) {
            return null;
        }
        return s2.get();
    }

    public void addToTipMap(Map<String, String> tips) {
        tips.put(this.getName(), this.getDescription());
        for (StatDefinition d : this.stats.keySet()) {
            tips.put(d.getName(), d.getDescription());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        TreeMap sortedStats;
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupName).append(": ");
        sb.append(this.groupDescription).append("\n");
        Map<StatDefinition, Stat<?>> map = this.stats;
        synchronized (map) {
            sortedStats = new TreeMap(this.stats);
        }
        for (Stat s2 : sortedStats.values()) {
            sb.append("\t").append(s2).append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringVerbose() {
        TreeMap sortedStats;
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupName).append(": ");
        sb.append(this.groupDescription).append("\n");
        Map<StatDefinition, Stat<?>> map = this.stats;
        synchronized (map) {
            sortedStats = new TreeMap(this.stats);
        }
        for (Stat s2 : sortedStats.values()) {
            sb.append("\t").append(s2.toStringVerbose()).append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringConcise() {
        TreeMap sortedStats;
        boolean headerPrinted = false;
        StringBuilder sb = new StringBuilder();
        Map<StatDefinition, Stat<?>> map = this.stats;
        synchronized (map) {
            sortedStats = new TreeMap(this.stats);
        }
        for (Stat s2 : sortedStats.values()) {
            if (s2.isNotSet()) continue;
            if (!headerPrinted) {
                sb.append(this.groupName + "\n");
                headerPrinted = true;
            }
            sb.append("\t").append(s2).append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCSVHeader() {
        StringBuilder sb = new StringBuilder();
        Map<StatDefinition, Stat<?>> map = this.stats;
        synchronized (map) {
            for (StatDefinition def : this.stats.keySet()) {
                sb.append(this.groupName + "_" + def.getName() + ",");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCSVData() {
        StringBuilder sb = new StringBuilder();
        Map<StatDefinition, Stat<?>> map = this.stats;
        synchronized (map) {
            for (Stat<?> s2 : this.stats.values()) {
                sb.append(s2.getFormattedValue() + ",");
            }
        }
        return sb.toString();
    }
}

