/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.compat.DbCompat;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Evolver;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.RecordOutput;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.raw.RawObject;
import com.sleepycat.persist.raw.RawType;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class EnumFormat
extends Format {
    private static final long serialVersionUID = 1069833955604373538L;
    private String[] names;
    private transient Object[] values;

    EnumFormat(Catalog catalog, Class type) {
        super(catalog, type);
        this.values = type.getEnumConstants();
        this.names = new String[this.values.length];
        for (int i = 0; i < this.names.length; ++i) {
            this.names[i] = ((Enum)this.values[i]).name();
        }
    }

    EnumFormat(Catalog catalog, Class type, String[] enumData) {
        super(catalog, type);
        this.names = enumData;
    }

    String[] getFormatData() {
        return this.names;
    }

    @Override
    public boolean isEnum() {
        return true;
    }

    @Override
    public List<String> getEnumConstants() {
        return Arrays.asList(this.names);
    }

    @Override
    void collectRelatedFormats(Catalog catalog, Map<String, Format> newFormats) {
    }

    @Override
    void initialize(Catalog catalog, EntityModel model, int initVersion) {
        if (this.values == null) {
            this.initValues();
        }
    }

    private void initValues() {
        Class cls = this.getType();
        if (cls != null) {
            this.values = new Object[this.names.length];
            for (int i = 0; i < this.names.length; ++i) {
                try {
                    this.values[i] = Enum.valueOf(cls, this.names[i]);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Deletion and renaming of enum values is not supported: " + this.names[i], e);
                }
            }
        }
    }

    @Override
    Object newArray(int len) {
        return Array.newInstance(this.getType(), len);
    }

    @Override
    public Object newInstance(EntityInput input, boolean rawAccess) {
        int index = input.readEnumConstant(this.names);
        if (rawAccess) {
            return new RawObject((RawType)this, this.names[index]);
        }
        return this.values[index];
    }

    @Override
    public Object readObject(Object o, EntityInput input, boolean rawAccess) {
        return o;
    }

    @Override
    void writeObject(Object o, EntityOutput output, boolean rawAccess) {
        if (rawAccess) {
            String name2 = ((RawObject)o).getEnum();
            for (int i = 0; i < this.names.length; ++i) {
                if (!this.names[i].equals(name2)) continue;
                output.writeEnumConstant(this.names, i);
                return;
            }
        } else {
            for (int i = 0; i < this.values.length; ++i) {
                if (o != this.values[i]) continue;
                output.writeEnumConstant(this.names, i);
                return;
            }
        }
        throw DbCompat.unexpectedState("Bad enum: " + o);
    }

    @Override
    Object convertRawObject(Catalog catalog, boolean rawAccess, RawObject rawObject, IdentityHashMap converted) {
        String name2 = rawObject.getEnum();
        for (int i = 0; i < this.names.length; ++i) {
            if (!this.names[i].equals(name2)) continue;
            Object o = this.values[i];
            converted.put(rawObject, o);
            return o;
        }
        throw new IllegalArgumentException("Enum constant is not defined: " + name2);
    }

    @Override
    void skipContents(RecordInput input) {
        input.skipFast(input.getPackedIntByteLength());
    }

    @Override
    void copySecKey(RecordInput input, RecordOutput output) {
        int len = input.getPackedIntByteLength();
        output.writeFast(input.getBufferBytes(), input.getBufferOffset(), len);
        input.skipFast(len);
    }

    @Override
    boolean evolve(Format newFormatParam, Evolver evolver) {
        List<String> oldNamesList;
        if (!(newFormatParam instanceof EnumFormat)) {
            evolver.addEvolveError(this, newFormatParam, "Incompatible enum type changed detected", "An enum class may not be changed to a non-enum type");
            return false;
        }
        EnumFormat newFormat = (EnumFormat)newFormatParam;
        if (Arrays.equals(this.names, newFormat.names)) {
            evolver.useOldFormat(this, newFormat);
            return true;
        }
        List<String> newNamesList = Arrays.asList(newFormat.names);
        HashSet<String> newNamesSet = new HashSet<String>(newNamesList);
        if (!newNamesSet.containsAll(oldNamesList = Arrays.asList(this.names))) {
            HashSet<String> oldNamesSet = new HashSet<String>(oldNamesList);
            oldNamesSet.removeAll(newNamesSet);
            evolver.addEvolveError(this, newFormat, "Incompatible enum type changed detected", "Enum values may not be removed: " + oldNamesSet);
        }
        ArrayList<String> additionalNamesList = new ArrayList<String>(newNamesList);
        additionalNamesList.removeAll(oldNamesList);
        int nAdditionalNames = additionalNamesList.size();
        if (nAdditionalNames == 0) {
            evolver.useOldFormat(this, newFormat);
            return true;
        }
        int nOldNames = this.names.length;
        newFormat.names = new String[nOldNames + nAdditionalNames];
        System.arraycopy(this.names, 0, newFormat.names, 0, nOldNames);
        for (int i = 0; i < nAdditionalNames; ++i) {
            newFormat.names[nOldNames + i] = (String)additionalNamesList.get(i);
        }
        newFormat.initValues();
        evolver.useEvolvedFormat(this, newFormat, newFormat);
        return true;
    }
}

