/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.io.Files;
import com.google.common.net.InetAddresses;
import com.google.common.net.InternetDomainName;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.dcache.nfs.InetAddressMatcher;
import org.dcache.nfs.v4.xdr.layouttype4;

public class FsExport {
    public static final int DEFAULT_ANON_UID = 65534;
    public static final int DEFAULT_ANON_GID = 65534;
    private final String _path;
    private final InetAddressMatcher _clientMatcher;
    private final Root _isTrusted;
    private final IO _rw;
    private final boolean _withAcl;
    private final Sec _sec;
    private final boolean _allSquash;
    private final int _anonUid;
    private final int _anonGid;
    private final boolean _withDcap;
    private final boolean _allRoot;
    private final int _index;
    private final boolean _withPnfs;
    private final List<layouttype4> _layoutTypes;
    private final boolean _requirePrivilegedClientPort;

    private FsExport(String path, FsExportBuilder builder) throws UnknownHostException {
        this._path = FsExport.normalize(path);
        this._clientMatcher = InetAddressMatcher.forPattern(builder.getClient());
        this._isTrusted = builder.getIsTrusted();
        this._rw = builder.getIo();
        this._withAcl = builder.isWithAcl();
        this._sec = builder.getSec();
        this._allSquash = builder.hasAllSquash();
        this._anonUid = builder.getAnonUid();
        this._anonGid = builder.getAnonGid();
        this._withDcap = builder.isWithDcap();
        this._allRoot = builder.isAllRoot();
        this._withPnfs = builder.isWithPnfs();
        this._index = FsExport.getExportIndex(this._path);
        this._layoutTypes = List.copyOf(builder.getLayoutTypes());
        this._requirePrivilegedClientPort = builder.isPrivilegedClientPortRequired();
    }

    public static int getExportIndex(String path) {
        int index = 1;
        for (String s2 : Splitter.on('/').omitEmptyStrings().split(path)) {
            index = 31 * index + s2.hashCode();
        }
        return index;
    }

    public String getPath() {
        return this._path;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._path).append(':').append(' ').append(this._clientMatcher.getPattern()).append('(').append((Object)this._rw).append(',').append(this._isTrusted == Root.TRUSTED ? "no_root_squash" : "root_squash").append(',').append(this._withAcl ? "acl" : "noacl").append(',').append("sec=").append((Object)this._sec).append(",").append(this._requirePrivilegedClientPort ? "secure" : "insecure").append(',').append(this._withDcap ? "dcap" : "no_dcap").append(',').append(this._withPnfs ? "pnfs" : "nopnfs");
        if (this._allSquash) {
            sb.append(",all_squash");
        }
        if (!this._layoutTypes.isEmpty()) {
            sb.append(this._layoutTypes.stream().map(Object::toString).map(s2 -> s2.substring("LAYOUT4_".length())).map(String::toLowerCase).collect(Collectors.joining(":", ",lt=", "")));
        }
        sb.append(',').append("anonuid=").append(this._anonUid);
        sb.append(',').append("anongid=").append(this._anonGid);
        sb.append(')').append(':').append("idx=").append(Integer.toHexString(this.getIndex()));
        return sb.toString();
    }

    public boolean isAllowed(InetAddress client) {
        return this._clientMatcher.match(client);
    }

    public boolean isTrusted() {
        return this._isTrusted == Root.TRUSTED;
    }

    public String client() {
        return this._clientMatcher.getPattern();
    }

    public IO ioMode() {
        return this._rw;
    }

    public int getIndex() {
        return this._index;
    }

    public boolean checkAcls() {
        return this._withAcl;
    }

    public Sec getSec() {
        return this._sec;
    }

    public boolean hasAllSquash() {
        return this._allSquash;
    }

    public int getAnonUid() {
        return this._anonUid;
    }

    public int getAnonGid() {
        return this._anonGid;
    }

    public boolean isWithDcap() {
        return this._withDcap;
    }

    public boolean isAllRoot() {
        return this._allRoot;
    }

    public boolean isWithPnfs() {
        return this._withPnfs;
    }

    public boolean isPrivilegedClientPortRequired() {
        return this._requirePrivilegedClientPort;
    }

    public List<layouttype4> getLayoutTypes() {
        return this._layoutTypes;
    }

    public static String normalize(String path) {
        return Files.simplifyPath(path);
    }

    public int hashCode() {
        int hash = 3;
        hash = 83 * hash + Objects.hashCode(this._path);
        hash = 83 * hash + Objects.hashCode(this._clientMatcher);
        hash = 83 * hash + Objects.hashCode((Object)this._isTrusted);
        hash = 83 * hash + Objects.hashCode((Object)this._rw);
        hash = 83 * hash + (this._withAcl ? 1 : 0);
        hash = 83 * hash + Objects.hashCode((Object)this._sec);
        hash = 83 * hash + (this._allSquash ? 1 : 0);
        hash = 83 * hash + this._anonUid;
        hash = 83 * hash + this._anonGid;
        hash = 83 * hash + (this._withDcap ? 1 : 0);
        hash = 83 * hash + (this._allRoot ? 1 : 0);
        hash = 83 * hash + this._index;
        hash = 83 * hash + (this._withPnfs ? 1 : 0);
        hash = 83 * hash + Objects.hashCode(this._layoutTypes);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FsExport other = (FsExport)obj;
        if (this._withAcl != other._withAcl) {
            return false;
        }
        if (this._allSquash != other._allSquash) {
            return false;
        }
        if (this._anonUid != other._anonUid) {
            return false;
        }
        if (this._anonGid != other._anonGid) {
            return false;
        }
        if (this._withDcap != other._withDcap) {
            return false;
        }
        if (this._allRoot != other._allRoot) {
            return false;
        }
        if (this._index != other._index) {
            return false;
        }
        if (this._withPnfs != other._withPnfs) {
            return false;
        }
        if (!Objects.equals(this._path, other._path)) {
            return false;
        }
        if (!Objects.equals(this._clientMatcher, other._clientMatcher)) {
            return false;
        }
        if (this._isTrusted != other._isTrusted) {
            return false;
        }
        if (this._rw != other._rw) {
            return false;
        }
        if (this._sec != other._sec) {
            return false;
        }
        return Objects.equals(this._layoutTypes, other._layoutTypes);
    }

    public static class FsExportBuilder {
        private String _client = "*";
        private IO _io = IO.RO;
        private Root _isTrusted = Root.NOTTRUSTED;
        private boolean _withAcl = false;
        private Sec _sec = Sec.SYS;
        private boolean allSquash = false;
        private int _anonUid = 65534;
        private int _anonGid = 65534;
        private boolean _withDcap = true;
        private boolean _allRoot = false;
        private boolean _withPnfs = true;
        private final List<layouttype4> _layoutTypes = new ArrayList<layouttype4>();
        private boolean _requirePrivilegedClientPort;

        public FsExportBuilder forClient(String client) {
            Preconditions.checkArgument(FsExportBuilder.isValidHostSpecifier(client), "bad host specifier: " + client);
            this._client = client;
            return this;
        }

        public FsExportBuilder withPrivilegedClientPort() {
            this._requirePrivilegedClientPort = true;
            return this;
        }

        public FsExportBuilder withoutPrivilegedClientPort() {
            this._requirePrivilegedClientPort = false;
            return this;
        }

        public boolean isPrivilegedClientPortRequired() {
            return this._requirePrivilegedClientPort;
        }

        public FsExportBuilder trusted() {
            this._isTrusted = Root.TRUSTED;
            return this;
        }

        public FsExportBuilder notTrusted() {
            this._isTrusted = Root.NOTTRUSTED;
            return this;
        }

        public FsExportBuilder ro() {
            this._io = IO.RO;
            return this;
        }

        public FsExportBuilder rw() {
            this._io = IO.RW;
            return this;
        }

        public FsExportBuilder withAcl() {
            this._withAcl = true;
            return this;
        }

        public FsExportBuilder withoutAcl() {
            this._withAcl = false;
            return this;
        }

        public FsExportBuilder withSec(Sec sec) {
            this._sec = sec;
            return this;
        }

        public FsExportBuilder withAnonUid(int id) {
            this._anonUid = id;
            return this;
        }

        public FsExportBuilder withAnonGid(int id) {
            this._anonGid = id;
            return this;
        }

        public FsExportBuilder allSquash() {
            this.allSquash = true;
            return this;
        }

        public FsExportBuilder withDcap() {
            this._withDcap = true;
            return this;
        }

        public FsExportBuilder withoutDcap() {
            this._withDcap = false;
            return this;
        }

        public FsExportBuilder withAllRoot() {
            this._allRoot = true;
            return this;
        }

        public FsExportBuilder withPnfs() {
            this._withPnfs = true;
            return this;
        }

        public FsExportBuilder withoutPnfs() {
            this._withPnfs = false;
            return this;
        }

        public FsExportBuilder withLayoutType(layouttype4 type) {
            this._layoutTypes.add(type);
            return this;
        }

        public String getClient() {
            return this._client;
        }

        public IO getIo() {
            return this._io;
        }

        public Root getIsTrusted() {
            return this._isTrusted;
        }

        public boolean isWithAcl() {
            return this._withAcl;
        }

        public Sec getSec() {
            return this._sec;
        }

        public boolean hasAllSquash() {
            return this.allSquash;
        }

        public int getAnonUid() {
            return this._anonUid;
        }

        public int getAnonGid() {
            return this._anonGid;
        }

        public boolean isWithDcap() {
            return this._withDcap;
        }

        public boolean isAllRoot() {
            return this._allRoot;
        }

        public boolean isWithPnfs() {
            return this._withPnfs;
        }

        public List<layouttype4> getLayoutTypes() {
            return this._layoutTypes;
        }

        public FsExport build(String path) throws UnknownHostException {
            return new FsExport(path, this);
        }

        private static boolean isValidHostSpecifier(String s2) {
            String mask;
            String host;
            int maskIdx = s2.indexOf(47);
            if (maskIdx < 0) {
                host = s2;
                mask = "128";
            } else {
                host = s2.substring(0, maskIdx);
                mask = s2.substring(maskIdx + 1);
            }
            return InetAddresses.isInetAddress(host) && FsExportBuilder.isValidNetmask(mask) || InternetDomainName.isValid(host) || FsExportBuilder.isValidWildcard(host);
        }

        private static boolean isValidWildcard(String s2) {
            return InternetDomainName.isValid(s2.replace('?', 'a').replace('*', 'a'));
        }

        private static boolean isValidNetmask(String s2) {
            try {
                int mask = Integer.parseInt(s2);
                return mask >= 0 && mask <= 128;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
    }

    public static enum Root {
        TRUSTED,
        NOTTRUSTED;

    }

    public static enum IO {
        RW,
        RO;

    }

    public static enum Sec {
        NONE,
        SYS,
        KRB5,
        KRB5I,
        KRB5P;

    }
}

