/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.util;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;

public class CacheElement<V> {
    private final Duration _maxLifeTime;
    private final Duration _idleTime;
    private final Instant _creationTime;
    private Instant _lastAccessTime;
    private final V _inner;
    private final Clock _clock;

    CacheElement(V inner, Clock clock, Duration maxLifeTime, Duration idleTime) {
        this._clock = clock;
        this._lastAccessTime = this._creationTime = this._clock.instant();
        this._inner = inner;
        this._maxLifeTime = maxLifeTime;
        this._idleTime = idleTime;
    }

    public V getObject() {
        this._lastAccessTime = this._clock.instant();
        return this._inner;
    }

    public V peekObject() {
        return this._inner;
    }

    public boolean validAt(Instant instant) {
        return Duration.between(this._lastAccessTime, instant).compareTo(this._idleTime) <= 0 && Duration.between(this._creationTime, instant).compareTo(this._maxLifeTime) <= 0;
    }

    public String toString() {
        Instant now = this._clock.instant();
        return String.format("Element: [%s], created: %s, last access: %s, life time %s, idle: %s, max idle: %s", this._inner.toString(), this._creationTime, this._lastAccessTime, this._maxLifeTime, Duration.between(this._lastAccessTime, now), this._idleTime);
    }
}

