/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class Misc {
    private Misc() {
    }

    public static Optional<Instant> getBuildTime() {
        try {
            Attributes as;
            String buildTime;
            ProtectionDomain pd = Misc.class.getProtectionDomain();
            CodeSource cs = pd.getCodeSource();
            URL u = cs.getLocation();
            InputStream is = u.openStream();
            JarInputStream jis = new JarInputStream(is);
            Manifest m4 = jis.getManifest();
            if (m4 != null && (buildTime = (as = m4.getMainAttributes()).getValue("Build-Time")) != null) {
                return Optional.of(Instant.parse(buildTime));
            }
        }
        catch (IOException | DateTimeParseException exception) {
            // empty catch block
        }
        return Optional.empty();
    }
}

