/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.util;

import com.sun.security.auth.UnixNumericGroupPrincipal;
import com.sun.security.auth.UnixNumericUserPrincipal;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.security.auth.Subject;

public class UnixSubjects {
    private UnixSubjects() {
    }

    public static boolean isRootSubject(Subject subject) {
        return UnixSubjects.hasUid(subject, 0L);
    }

    public static boolean isNobodySubject(Subject subject) {
        return subject.getPrincipals().stream().noneMatch(UnixNumericUserPrincipal.class::isInstance);
    }

    public static boolean hasUid(Subject subject, long uid) {
        return subject.getPrincipals().stream().filter(UnixNumericUserPrincipal.class::isInstance).map(UnixNumericUserPrincipal.class::cast).anyMatch(p -> p.longValue() == uid);
    }

    public static boolean hasGid(Subject subject, long gid) {
        return subject.getPrincipals().stream().filter(UnixNumericGroupPrincipal.class::isInstance).map(UnixNumericGroupPrincipal.class::cast).anyMatch(p -> p.longValue() == gid);
    }

    public static Subject toSubject(long uid, long gid) {
        return new Subject(false, Set.of(new UnixNumericUserPrincipal(uid), new UnixNumericGroupPrincipal(gid, true)), Set.of(), Set.of());
    }

    public static Subject toSubject(long uid, long gid, long ... gids) {
        Subject subject = UnixSubjects.toSubject(uid, gid);
        subject.getPrincipals().addAll(Arrays.stream(gids).mapToObj(l -> new UnixNumericGroupPrincipal(l, false)).collect(Collectors.toSet()));
        return subject;
    }

    public static long getUid(Subject subject) {
        return subject.getPrincipals().stream().filter(UnixNumericUserPrincipal.class::isInstance).map(UnixNumericUserPrincipal.class::cast).mapToLong(UnixNumericUserPrincipal::longValue).findFirst().getAsLong();
    }

    public static long getPrimaryGid(Subject subject) {
        return subject.getPrincipals().stream().filter(UnixNumericGroupPrincipal.class::isInstance).map(UnixNumericGroupPrincipal.class::cast).filter(UnixNumericGroupPrincipal::isPrimaryGroup).mapToLong(UnixNumericGroupPrincipal::longValue).findFirst().getAsLong();
    }

    public static long[] getSecondaryGids(Subject subject) {
        return subject.getPrincipals().stream().filter(UnixNumericGroupPrincipal.class::isInstance).map(UnixNumericGroupPrincipal.class::cast).filter(Predicate.not(UnixNumericGroupPrincipal::isPrimaryGroup)).mapToLong(UnixNumericGroupPrincipal::longValue).toArray();
    }
}

