/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v3;

import com.google.common.base.Splitter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.ExportTable;
import org.dcache.nfs.FsExport;
import org.dcache.nfs.status.NotDirException;
import org.dcache.nfs.status.PermException;
import org.dcache.nfs.v3.xdr.dirpath;
import org.dcache.nfs.v3.xdr.exportnode;
import org.dcache.nfs.v3.xdr.exports;
import org.dcache.nfs.v3.xdr.fhandle3;
import org.dcache.nfs.v3.xdr.fhstatus;
import org.dcache.nfs.v3.xdr.groupnode;
import org.dcache.nfs.v3.xdr.groups;
import org.dcache.nfs.v3.xdr.mount_protServerStub;
import org.dcache.nfs.v3.xdr.mountbody;
import org.dcache.nfs.v3.xdr.mountlist;
import org.dcache.nfs.v3.xdr.mountres3;
import org.dcache.nfs.v3.xdr.mountres3_ok;
import org.dcache.nfs.v3.xdr.name;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.PseudoFs;
import org.dcache.nfs.vfs.Stat;
import org.dcache.nfs.vfs.VirtualFileSystem;
import org.dcache.oncrpc4j.rpc.RpcCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MountServer
extends mount_protServerStub {
    private static final Logger _log = LoggerFactory.getLogger(MountServer.class);
    private final ExportTable _exports;
    private final Multimap<String, InetAddress> _mounts = HashMultimap.create();
    private final VirtualFileSystem _vfs;
    public static final int RPC_AUTH_GSS_KRB5 = 390003;
    public static final int RPC_AUTH_GSS_KRB5I = 390004;
    public static final int RPC_AUTH_GSS_KRB5P = 390005;

    public MountServer(ExportTable exports2, VirtualFileSystem fs) {
        this._exports = exports2;
        this._vfs = fs;
    }

    @Override
    public void MOUNTPROC3_NULL_3(RpcCall call$) {
    }

    @Override
    public mountres3 MOUNTPROC3_MNT_3(RpcCall call$, dirpath arg1) {
        mountres3 m4 = new mountres3();
        Path p = Paths.get(arg1.value, new String[0]);
        String mountPoint = p.toString().replace("\\", "/");
        InetAddress remoteAddress = call$.getTransport().getRemoteSocketAddress().getAddress();
        _log.debug("Mount request for: {}", (Object)mountPoint);
        FsExport export = this._exports.getExport(mountPoint, remoteAddress);
        if (export == null) {
            m4.fhs_status = 13;
            _log.info("Mount deny for: {}:{}", (Object)remoteAddress, (Object)mountPoint);
            return m4;
        }
        m4.mountinfo = new mountres3_ok();
        try {
            Inode rootInode = MountServer.path2Inode(this._vfs, mountPoint);
            Stat stat = this._vfs.getattr(rootInode);
            if (stat.type() == Stat.Type.SYMLINK) {
                String path = this._vfs.readlink(rootInode);
                rootInode = MountServer.path2Inode(this._vfs, path);
                stat = this._vfs.getattr(rootInode);
            }
            if (stat.type() != Stat.Type.DIRECTORY) {
                throw new NotDirException("Path is not a directory");
            }
            byte[] b = PseudoFs.pseudoIdToReal(rootInode, export.getIndex()).toNfsHandle();
            m4.fhs_status = 0;
            m4.mountinfo.fhandle = new fhandle3(b);
            m4.mountinfo.auth_flavors = this.exportSecFlavors(export);
            this._mounts.put(mountPoint, remoteAddress);
        }
        catch (ChimeraNFSException e) {
            _log.warn("mount request failed: {}", (Object)e.getMessage());
            m4.fhs_status = e.getStatus();
        }
        catch (IOException e) {
            m4.fhs_status = 10006;
        }
        return m4;
    }

    @Override
    public mountlist MOUNTPROC3_DUMP_3(RpcCall call$) {
        mountlist mFullList;
        mountlist mList = mFullList = new mountlist();
        mList.value = null;
        for (Map.Entry<String, InetAddress> mountEntry : this._mounts.entries()) {
            String path = mountEntry.getKey();
            InetAddress remoteAddress = mountEntry.getValue();
            mList.value = new mountbody();
            mList.value.ml_directory = new dirpath(path);
            mList.value.ml_hostname = new name(remoteAddress.getHostName());
            mList.value.ml_next = new mountlist();
            mList.value.ml_next.value = null;
            mList = mList.value.ml_next;
        }
        return mFullList;
    }

    @Override
    public void MOUNTPROC3_UMNT_3(RpcCall call$, dirpath arg1) {
        this._mounts.remove(arg1.value, call$.getTransport().getRemoteSocketAddress().getAddress());
    }

    @Override
    public void MOUNTPROC3_UMNTALL_3(RpcCall call$) {
    }

    @Override
    public exports MOUNTPROC3_EXPORT_3(RpcCall call$) {
        exports eFullList;
        exports eList = eFullList = new exports();
        eList.value = null;
        Map<String, List<FsExport>> exports2 = this._exports.exports().collect(Collectors.groupingBy(FsExport::getPath));
        for (String path : exports2.keySet()) {
            eList.value = new exportnode();
            eList.value.ex_dir = new dirpath(path);
            eList.value.ex_groups = new groups();
            eList.value.ex_groups.value = null;
            groups g2 = eList.value.ex_groups;
            for (FsExport export : exports2.get(path)) {
                g2.value = new groupnode();
                g2.value.gr_name = new name(export.client());
                g2.value.gr_next = new groups();
                g2.value.gr_next.value = null;
                g2 = g2.value.gr_next;
            }
            eList.value.ex_next = new exports();
            eList.value.ex_next.value = null;
            eList = eList.value.ex_next;
        }
        return eFullList;
    }

    @Override
    public void MOUNTPROC_NULL_1(RpcCall call$) {
    }

    @Override
    public fhstatus MOUNTPROC_MNT_1(RpcCall call$, dirpath arg1) {
        return null;
    }

    @Override
    public mountlist MOUNTPROC_DUMP_1(RpcCall call$) {
        return this.MOUNTPROC3_DUMP_3(call$);
    }

    @Override
    public void MOUNTPROC_UMNT_1(RpcCall call$, dirpath arg1) {
        this.MOUNTPROC3_UMNT_3(call$, arg1);
    }

    @Override
    public void MOUNTPROC_UMNTALL_1(RpcCall call$) {
    }

    @Override
    public exports MOUNTPROC_EXPORT_1(RpcCall call$) {
        return this.MOUNTPROC3_EXPORT_3(call$);
    }

    @Override
    public exports MOUNTPROC_EXPORTALL_1(RpcCall call$) {
        return null;
    }

    private static Inode path2Inode(VirtualFileSystem fs, String path) throws ChimeraNFSException, IOException {
        Splitter splitter = Splitter.on('/').omitEmptyStrings();
        Inode inode = fs.getRootInode();
        for (String pathElement : splitter.split(path)) {
            inode = fs.lookup(inode, pathElement);
        }
        return inode;
    }

    private int[] exportSecFlavors(FsExport export) throws ChimeraNFSException {
        FsExport.Sec sec = export.getSec();
        return switch (sec) {
            case FsExport.Sec.KRB5 -> new int[]{390003, 390004, 390005};
            case FsExport.Sec.KRB5I -> new int[]{390004, 390005};
            case FsExport.Sec.KRB5P -> new int[]{390005};
            case FsExport.Sec.SYS -> new int[]{390003, 390004, 390005, 1};
            case FsExport.Sec.NONE -> new int[]{390003, 390004, 390005, 1, 0};
            default -> throw new PermException("Unsupported secutiry flavor");
        };
    }
}

