/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v3;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.dcache.nfs.status.AccessException;
import org.dcache.nfs.status.NameTooLongException;
import org.dcache.nfs.v3.xdr.fattr3;
import org.dcache.nfs.v3.xdr.fileid3;
import org.dcache.nfs.v3.xdr.gid3;
import org.dcache.nfs.v3.xdr.mode3;
import org.dcache.nfs.v3.xdr.nfstime3;
import org.dcache.nfs.v3.xdr.post_op_attr;
import org.dcache.nfs.v3.xdr.pre_op_attr;
import org.dcache.nfs.v3.xdr.sattr3;
import org.dcache.nfs.v3.xdr.size3;
import org.dcache.nfs.v3.xdr.specdata3;
import org.dcache.nfs.v3.xdr.uid3;
import org.dcache.nfs.v3.xdr.uint32;
import org.dcache.nfs.v3.xdr.uint64;
import org.dcache.nfs.v3.xdr.wcc_attr;
import org.dcache.nfs.v3.xdr.wcc_data;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.nfs.vfs.VirtualFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final int MODE_MASK = 258048;
    private static final Logger _log = LoggerFactory.getLogger(Utils.class);

    private Utils() {
    }

    public static void fill_attributes(Stat stat, fattr3 at) {
        at.type = Utils.unixType2NFS(stat.getMode());
        at.mode = new mode3(new uint32(stat.getMode() & 0x3FFFF));
        at.nlink = new uint32(stat.getNlink());
        at.uid = new uid3(stat.getUid());
        at.gid = new gid3(stat.getGid());
        at.rdev = new specdata3();
        at.rdev.specdata1 = new uint32(19);
        at.rdev.specdata2 = new uint32(17);
        at.fsid = new uint64(stat.getDev());
        at.fileid = new fileid3(new uint64(stat.getIno()));
        at.size = new size3(stat.getSize());
        at.used = new size3(stat.getSize());
        at.atime = Utils.convertTimestamp(stat.getATime());
        at.mtime = Utils.convertTimestamp(stat.getMTime());
        at.ctime = Utils.convertTimestamp(stat.getCTime());
    }

    public static void fill_attributes(Stat stat, wcc_attr at) {
        at.size = new size3(stat.getSize());
        at.mtime = Utils.convertTimestamp(stat.getMTime());
        at.ctime = Utils.convertTimestamp(stat.getCTime());
    }

    public static nfstime3 convertTimestamp(long gmtMillis) {
        nfstime3 result = new nfstime3();
        result.seconds = new uint32((int)TimeUnit.SECONDS.convert(gmtMillis, TimeUnit.MILLISECONDS));
        result.nseconds = new uint32((int)(1000000L * (gmtMillis % 1000L)));
        return result;
    }

    public static long convertTimestamp(nfstime3 gmtNanos) {
        return (long)gmtNanos.seconds.value * 1000L + (long)gmtNanos.nseconds.value / 1000000L;
    }

    public static void set_sattr(Inode inode, VirtualFileSystem fs, sattr3 s2) throws IOException {
        Stat stat = new Stat();
        long now = System.currentTimeMillis();
        if (s2.uid.set_it) {
            stat.setUid(s2.uid.uid.value);
        }
        if (s2.gid.set_it) {
            stat.setGid(s2.gid.gid.value);
        }
        if (s2.mode.set_it) {
            int mode = s2.mode.mode.value.value;
            _log.debug("New mode [{}]", (Object)Integer.toOctalString(mode));
            stat.setMode(mode);
        }
        if (s2.size.set_it) {
            stat.setSize(s2.size.size.value);
        }
        switch (s2.mtime.set_it) {
            case 1: {
                stat.setMTime(now);
                break;
            }
            case 2: {
                long mtime = TimeUnit.MILLISECONDS.convert(s2.mtime.mtime.seconds.value, TimeUnit.SECONDS) + TimeUnit.MILLISECONDS.convert(s2.mtime.mtime.nseconds.value, TimeUnit.NANOSECONDS);
                stat.setMTime(mtime);
                break;
            }
        }
        fs.setattr(inode, stat);
    }

    static int unixType2NFS(int type) {
        return switch (type & 0x3F000) {
            case 32768 -> 1;
            case 16384 -> 2;
            case 40960 -> 5;
            case 49152 -> 6;
            case 24576 -> 3;
            case 8192 -> 4;
            case 4096 -> 7;
            default -> {
                _log.info("Unknown mode [{}]", (Object)Integer.toOctalString(type));
                yield 0;
            }
        };
    }

    public static post_op_attr defaultPostOpAttr() {
        post_op_attr postOpAttr = new post_op_attr();
        postOpAttr.attributes_follow = false;
        return postOpAttr;
    }

    public static pre_op_attr defaultPreOpAttr() {
        pre_op_attr preOpAttr = new pre_op_attr();
        preOpAttr.attributes_follow = false;
        return preOpAttr;
    }

    public static wcc_data defaultWccData() {
        wcc_data wccData = new wcc_data();
        wccData.after = Utils.defaultPostOpAttr();
        wccData.before = Utils.defaultPreOpAttr();
        return wccData;
    }

    public static void checkFilename(String filename) throws AccessException, NameTooLongException {
        if (filename.length() > 256) {
            throw new NameTooLongException();
        }
        if (filename.length() == 0 || filename.indexOf(47) != -1 || filename.indexOf(0) != -1) {
            throw new AccessException();
        }
    }
}

