/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.dcache.nfs.status.InvalException;
import org.dcache.nfs.v4.OperationGETATTR;
import org.dcache.nfs.v4.xdr.fattr4;
import org.dcache.nfs.v4.xdr.fattr4_acl;
import org.dcache.nfs.v4.xdr.fattr4_fs_layout_types;
import org.dcache.nfs.v4.xdr.fattr4_fs_locations;
import org.dcache.nfs.v4.xdr.fattr4_lease_time;
import org.dcache.nfs.v4.xdr.fattr4_size;
import org.dcache.nfs.v4.xdr.fattr4_type;
import org.dcache.nfs.v4.xdr.int32_t;
import org.dcache.nfs.v4.xdr.mode4;
import org.dcache.nfs.v4.xdr.nfs_fh4;
import org.dcache.nfs.v4.xdr.nfstime4;
import org.dcache.nfs.v4.xdr.settime4;
import org.dcache.nfs.v4.xdr.utf8str_cs;
import org.dcache.oncrpc4j.rpc.OncRpcException;
import org.dcache.oncrpc4j.xdr.Xdr;
import org.dcache.oncrpc4j.xdr.XdrAble;
import org.dcache.oncrpc4j.xdr.XdrDecodingStream;

public class AttributeMap {
    private final Map<Integer, ? extends XdrAble> _attrs;

    public AttributeMap(fattr4 attributes) throws OncRpcException, IOException {
        this._attrs = AttributeMap.asMap(attributes);
    }

    public <T extends XdrAble> Optional<T> get(Integer attr) {
        return Optional.ofNullable(this._attrs.get(attr));
    }

    private static Map<Integer, XdrAble> asMap(fattr4 attributes) throws OncRpcException, IOException {
        HashMap<Integer, XdrAble> attrs = new HashMap<Integer, XdrAble>();
        if (attributes != null) {
            int[] mask = attributes.attrmask.value;
            try (Xdr xdr = new Xdr(attributes.attr_vals.value);){
                xdr.beginDecoding();
                if (mask.length != 0) {
                    int maxAttr = 32 * mask.length;
                    for (int i = 0; i < maxAttr; ++i) {
                        int bitmapIdx = i / 32;
                        int newmask = mask[bitmapIdx] >> i % 32;
                        if (((long)newmask & 1L) == 0L) continue;
                        AttributeMap.xdr2fattr(attrs, i, xdr);
                    }
                }
                xdr.endDecoding();
            }
        }
        return attrs;
    }

    private static void xdr2fattr(Map<Integer, XdrAble> attrs, int fattr, XdrDecodingStream xdr) throws OncRpcException, IOException {
        XdrAble attr = switch (fattr) {
            case 4 -> new fattr4_size();
            case 12 -> new fattr4_acl();
            case 14 -> new int32_t();
            case 25 -> new int32_t();
            case 32 -> new utf8str_cs();
            case 33 -> new mode4();
            case 36 -> new utf8str_cs();
            case 37 -> new utf8str_cs();
            case 46 -> new int32_t();
            case 48 -> new settime4();
            case 49 -> new nfstime4();
            case 50 -> new nfstime4();
            case 54 -> new settime4();
            case 24 -> new fattr4_fs_locations();
            case 1 -> new fattr4_type();
            case 10 -> new fattr4_lease_time();
            case 19 -> new nfs_fh4();
            case 62 -> new fattr4_fs_layout_types();
            default -> throw new InvalException("invalid attribute: " + OperationGETATTR.attrMask2String(fattr));
        };
        attr.xdrDecode(xdr);
        attrs.put(fattr, attr);
    }
}

