/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import org.dcache.nfs.status.BadOwnerException;
import org.dcache.nfs.v4.NfsIdMapping;

public class CachingIdmap
implements NfsIdMapping {
    private final NfsIdMapping _inner;
    private final LoadingCache<String, Integer> _uidByNameCache;
    private final LoadingCache<String, Integer> _gidByNameCache;
    private final LoadingCache<Integer, String> _userNameByIdCache;
    private final LoadingCache<Integer, String> _groupNameByIdCache;

    public CachingIdmap(NfsIdMapping idmapd, int size, long timeout) {
        this._inner = idmapd;
        this._uidByNameCache = CacheBuilder.newBuilder().expireAfterWrite(timeout, TimeUnit.SECONDS).softValues().maximumSize(size).build(new ForwardUidMapping());
        this._gidByNameCache = CacheBuilder.newBuilder().expireAfterWrite(timeout, TimeUnit.SECONDS).softValues().maximumSize(size).build(new ForwardGidMapping());
        this._userNameByIdCache = CacheBuilder.newBuilder().expireAfterWrite(timeout, TimeUnit.SECONDS).softValues().maximumSize(size).build(new ReverseUidMapping());
        this._groupNameByIdCache = CacheBuilder.newBuilder().expireAfterWrite(timeout, TimeUnit.SECONDS).softValues().maximumSize(size).build(new ReverseGidMapping());
    }

    @Override
    public String uidToPrincipal(int id) {
        return this._userNameByIdCache.getUnchecked(id);
    }

    @Override
    public String gidToPrincipal(int id) {
        return this._groupNameByIdCache.getUnchecked(id);
    }

    @Override
    public int principalToUid(String principal) {
        return this._uidByNameCache.getUnchecked(principal);
    }

    @Override
    public int principalToGid(String principal) {
        return this._gidByNameCache.getUnchecked(principal);
    }

    private class ForwardUidMapping
    extends CacheLoader<String, Integer> {
        private ForwardUidMapping() {
        }

        @Override
        public Integer load(String s2) throws BadOwnerException {
            return CachingIdmap.this._inner.principalToUid(s2);
        }
    }

    private class ForwardGidMapping
    extends CacheLoader<String, Integer> {
        private ForwardGidMapping() {
        }

        @Override
        public Integer load(String s2) throws BadOwnerException {
            return CachingIdmap.this._inner.principalToGid(s2);
        }
    }

    private class ReverseUidMapping
    extends CacheLoader<Integer, String> {
        private ReverseUidMapping() {
        }

        @Override
        public String load(Integer id) {
            return CachingIdmap.this._inner.uidToPrincipal(id);
        }
    }

    private class ReverseGidMapping
    extends CacheLoader<Integer, String> {
        private ReverseGidMapping() {
        }

        @Override
        public String load(Integer id) {
            return CachingIdmap.this._inner.gidToPrincipal(id);
        }
    }
}

