/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.util.Objects;
import org.dcache.nfs.ExportTable;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NFSv41DeviceManager;
import org.dcache.nfs.v4.NFSv4StateHandler;
import org.dcache.nfs.v4.nlm.LockManager;
import org.dcache.nfs.v4.xdr.nfs_impl_id4;
import org.dcache.nfs.v4.xdr.verifier4;
import org.dcache.nfs.vfs.VirtualFileSystem;
import org.dcache.oncrpc4j.rpc.RpcCall;

public class CompoundContextBuilder {
    private LockManager lm;
    private RpcCall call = null;
    private int minorversion = 0;
    private VirtualFileSystem fs = null;
    private NFSv4StateHandler stateHandler = null;
    private NFSv41DeviceManager deviceManager = null;
    private ExportTable exportTable = null;
    private int exchangeIdFlags = 65536;
    private verifier4 rebootVerifier;
    private nfs_impl_id4 implId;

    public CompoundContextBuilder withCall(RpcCall call) {
        this.call = call;
        return this;
    }

    public CompoundContextBuilder withDeviceManager(NFSv41DeviceManager deviceManager) {
        this.deviceManager = deviceManager;
        return this;
    }

    public CompoundContextBuilder withExportTable(ExportTable exportTable) {
        this.exportTable = exportTable;
        return this;
    }

    public CompoundContextBuilder withFs(VirtualFileSystem fs) {
        this.fs = fs;
        return this;
    }

    public CompoundContextBuilder withMinorversion(int minorversion) {
        this.minorversion = minorversion;
        return this;
    }

    public CompoundContextBuilder withStateHandler(NFSv4StateHandler stateHandler) {
        this.stateHandler = stateHandler;
        return this;
    }

    public CompoundContextBuilder withLockManager(LockManager lm) {
        this.lm = lm;
        return this;
    }

    public CompoundContextBuilder withImplementationId(nfs_impl_id4 impId) {
        this.implId = impId;
        return this;
    }

    public LockManager getLm() {
        return this.lm;
    }

    public RpcCall getCall() {
        return this.call;
    }

    public int getMinorversion() {
        return this.minorversion;
    }

    public VirtualFileSystem getFs() {
        return this.fs;
    }

    public NFSv4StateHandler getStateHandler() {
        return this.stateHandler;
    }

    public NFSv41DeviceManager getDeviceManager() {
        return this.deviceManager;
    }

    public ExportTable getExportTable() {
        return this.exportTable;
    }

    public nfs_impl_id4 getImplementationId() {
        return this.implId;
    }

    public CompoundContext build() {
        Objects.requireNonNull(this.call);
        return new CompoundContext(this);
    }

    public int getExchangeIdFlags() {
        return this.exchangeIdFlags;
    }

    public CompoundContextBuilder withPnfsRoleDS() {
        this.exchangeIdFlags &= 0xFFFEFFFF;
        this.exchangeIdFlags |= 0x40000;
        return this;
    }

    public CompoundContextBuilder withPnfsRoleMDS() {
        this.exchangeIdFlags &= 0xFFFEFFFF;
        this.exchangeIdFlags |= 0x20000;
        return this;
    }

    public CompoundContextBuilder withoutPnfs() {
        this.exchangeIdFlags &= 0xFFF8FFFF;
        this.exchangeIdFlags |= 0x10000;
        return this;
    }

    public CompoundContextBuilder withRebootVerifier(verifier4 verifier) {
        this.rebootVerifier = verifier;
        return this;
    }

    public verifier4 getRebootVerifier() {
        return this.rebootVerifier;
    }
}

