/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.time.Duration;
import java.util.stream.Stream;
import org.dcache.nfs.util.Cache;
import org.dcache.nfs.util.CacheElement;
import org.dcache.nfs.util.CacheEventListener;
import org.dcache.nfs.v4.ClientCache;
import org.dcache.nfs.v4.NFS4Client;
import org.dcache.nfs.v4.xdr.clientid4;

public class DefaultClientCache
extends Cache<clientid4, NFS4Client>
implements ClientCache {
    public DefaultClientCache(Duration leaseTime, CacheEventListener<clientid4, NFS4Client> eventListener) {
        super("NFSv41 clients", 5000, Duration.ofSeconds(Long.MAX_VALUE), leaseTime.multipliedBy(2L), eventListener);
    }

    @Override
    public Stream<NFS4Client> stream() {
        return this.entries().stream().map(CacheElement::getObject);
    }

    @Override
    public Stream<NFS4Client> peek() {
        return this.entries().stream().map(CacheElement::peekObject);
    }
}

