/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import com.google.common.util.concurrent.Striped;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.BadStateidException;
import org.dcache.nfs.status.InvalException;
import org.dcache.nfs.status.ShareDeniedException;
import org.dcache.nfs.util.Opaque;
import org.dcache.nfs.v4.NFS4Client;
import org.dcache.nfs.v4.NFS4State;
import org.dcache.nfs.v4.StateOwner;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.nfs.vfs.Inode;

public class FileTracker {
    private final Striped<Lock> filesLock = Striped.lock(Runtime.getRuntime().availableProcessors() * 4);
    private final Map<Opaque, List<OpenState>> files = new ConcurrentHashMap<Opaque, List<OpenState>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public stateid4 addOpen(NFS4Client client, StateOwner owner, Inode inode, int shareAccess, int shareDeny) throws ChimeraNFSException {
        Opaque fileId = new Opaque(inode.getFileId());
        Lock lock = this.filesLock.get(fileId);
        lock.lock();
        try {
            List opens = this.files.computeIfAbsent(fileId, x -> new ArrayList(1));
            if (opens.stream().filter(o -> o.client.isLeaseValid()).anyMatch(o -> (shareAccess & o.getShareDeny()) != 0 || (shareDeny & o.getShareAccess()) != 0)) {
                throw new ShareDeniedException("Conflicting share");
            }
            for (OpenState os : opens) {
                if (os.client.getId() != client.getId() || !os.getOwner().equals(owner)) continue;
                os.shareAccess |= shareAccess;
                os.shareDeny |= shareDeny;
                ++os.stateid.seqid;
                stateid4 stateid42 = new stateid4(os.stateid.other, os.stateid.seqid);
                return stateid42;
            }
            NFS4State state = client.createState(owner);
            stateid4 stateid = state.stateid();
            OpenState openState = new OpenState(client, owner, stateid, shareAccess, shareDeny);
            opens.add(openState);
            state.addDisposeListener(s2 -> this.removeOpen(inode, stateid));
            ++stateid.seqid;
            stateid4 stateid43 = new stateid4(stateid.other, stateid.seqid);
            return stateid43;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public stateid4 downgradeOpen(NFS4Client client, stateid4 stateid, Inode inode, int shareAccess, int shareDeny) throws ChimeraNFSException {
        Opaque fileId = new Opaque(inode.getFileId());
        Lock lock = this.filesLock.get(fileId);
        lock.lock();
        try {
            List<OpenState> opens = this.files.get(fileId);
            OpenState os = opens.stream().filter(s2 -> client.getId() == s2.client.getId()).filter(s2 -> s2.stateid.equals(stateid)).findFirst().orElseThrow(BadStateidException::new);
            if ((os.shareAccess & shareAccess) != shareAccess) {
                throw new InvalException("downgrading to not owned share_access mode");
            }
            if ((os.shareDeny & shareDeny) != shareDeny) {
                throw new InvalException("downgrading to not owned share_deny mode");
            }
            os.shareAccess = shareAccess;
            os.shareDeny = shareDeny;
            ++os.stateid.seqid;
            stateid4 stateid42 = new stateid4(os.stateid.other, os.stateid.seqid);
            return stateid42;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeOpen(Inode inode, stateid4 stateid) {
        Opaque fileId = new Opaque(inode.getFileId());
        Lock lock = this.filesLock.get(fileId);
        lock.lock();
        try {
            List<OpenState> opens = this.files.get(fileId);
            if (opens != null) {
                Iterator<OpenState> osi = opens.iterator();
                while (osi.hasNext()) {
                    OpenState os = osi.next();
                    if (!os.stateid.equals(stateid)) continue;
                    osi.remove();
                    break;
                }
                if (opens.isEmpty()) {
                    this.files.remove(fileId);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getShareAccess(NFS4Client client, Inode inode, stateid4 stateid) throws BadStateidException {
        Opaque fileId = new Opaque(inode.getFileId());
        Lock lock = this.filesLock.get(fileId);
        lock.lock();
        try {
            List<OpenState> opens = this.files.get(fileId);
            if (opens == null) {
                throw new BadStateidException("no matching open");
            }
            int n = opens.stream().filter(s2 -> client.getId() == s2.client.getId()).filter(s2 -> s2.stateid.equals(stateid)).map(OpenState::getShareAccess).findFirst().orElseThrow(BadStateidException::new);
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    public Map<Inode, Collection<NFS4Client>> getOpenFiles() {
        return this.files.entrySet().stream().collect(Collectors.toMap(e -> Inode.forFile(((Opaque)e.getKey()).getOpaque()), e -> ((List)e.getValue()).stream().map(OpenState::getClient).collect(Collectors.toSet())));
    }

    private static class OpenState {
        private final NFS4Client client;
        private final stateid4 stateid;
        private final StateOwner owner;
        private int shareAccess;
        private int shareDeny;

        public OpenState(NFS4Client client, StateOwner owner, stateid4 stateid, int shareAccess, int shareDeny) {
            this.client = client;
            this.stateid = stateid;
            this.shareAccess = shareAccess;
            this.shareDeny = shareDeny;
            this.owner = owner;
        }

        public stateid4 getStateid() {
            return this.stateid;
        }

        public int getShareAccess() {
            return this.shareAccess;
        }

        public int getShareDeny() {
            return this.shareDeny;
        }

        public StateOwner getOwner() {
            return this.owner;
        }

        public NFS4Client getClient() {
            return this.client;
        }
    }
}

