/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import com.google.common.io.BaseEncoding;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.BadSeqidException;
import org.dcache.nfs.status.BadSessionException;
import org.dcache.nfs.status.BadStateidException;
import org.dcache.nfs.status.CompleteAlreadyException;
import org.dcache.nfs.status.ExpiredException;
import org.dcache.nfs.status.NoGraceException;
import org.dcache.nfs.status.SeqMisorderedException;
import org.dcache.nfs.status.StaleClientidException;
import org.dcache.nfs.util.Opaque;
import org.dcache.nfs.v4.ClientCB;
import org.dcache.nfs.v4.NFS4State;
import org.dcache.nfs.v4.NFSv41Session;
import org.dcache.nfs.v4.NFSv4StateHandler;
import org.dcache.nfs.v4.StateOwner;
import org.dcache.nfs.v4.xdr.clientid4;
import org.dcache.nfs.v4.xdr.seqid4;
import org.dcache.nfs.v4.xdr.sessionid4;
import org.dcache.nfs.v4.xdr.state_owner4;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.nfs.v4.xdr.verifier4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NFS4Client {
    private static final Logger _log = LoggerFactory.getLogger(NFS4Client.class);
    private final AtomicInteger _stateIdCounter = new AtomicInteger(0);
    private final byte[] _ownerId;
    private final verifier4 _verifier;
    private final Principal _principal;
    private final clientid4 _clientId;
    private boolean _isConfirmed = false;
    private int _sessionSequence = 1;
    private final Map<stateid4, NFS4State> _clientStates = new ConcurrentHashMap<stateid4, NFS4State>();
    private final Map<sessionid4, NFSv41Session> _sessions = new HashMap<sessionid4, NFSv41Session>();
    private volatile Instant _lastLeaseUpdate;
    private final Map<Opaque, StateOwner> _owners = new HashMap<Opaque, StateOwner>();
    private final InetSocketAddress _clientAddress;
    private final InetSocketAddress _localAddress;
    private ClientCB _cl_cb = null;
    private final Duration _leaseTime;
    private boolean _reclaim_completed;
    private final boolean _callbackNeeded;
    private final int _minorVersion;
    private final NFSv4StateHandler _stateHandler;
    private final Clock _clock;

    public NFS4Client(NFSv4StateHandler stateHandler, clientid4 clientId, int minorVersion, InetSocketAddress clientAddress, InetSocketAddress localAddress, byte[] ownerID, verifier4 verifier, Principal principal, Duration leaseTime, boolean calbackNeeded) {
        this._stateHandler = stateHandler;
        this._clock = this._stateHandler.getClock();
        this._ownerId = Arrays.copyOf(ownerID, ownerID.length);
        this._verifier = verifier;
        this._principal = principal;
        this._clientId = clientId;
        this._clientAddress = clientAddress;
        this._localAddress = localAddress;
        this._lastLeaseUpdate = this._clock.instant();
        this._leaseTime = leaseTime;
        this._callbackNeeded = calbackNeeded;
        this._minorVersion = minorVersion;
        this._reclaim_completed = this._minorVersion == 0;
        _log.debug("New client: {}", (Object)this);
    }

    public void setCB(ClientCB cb) {
        this._cl_cb = cb;
    }

    public ClientCB getCB() {
        return this._cl_cb;
    }

    public int getMinorVersion() {
        return this._minorVersion;
    }

    public byte[] getOwnerId() {
        return this._ownerId;
    }

    public verifier4 verifier() {
        return this._verifier;
    }

    public clientid4 getId() {
        return this._clientId;
    }

    public boolean verifierEquals(verifier4 verifier) {
        return this._verifier.equals(verifier);
    }

    public synchronized boolean isConfirmed() {
        return this._isConfirmed;
    }

    public synchronized void setConfirmed() {
        this._isConfirmed = true;
    }

    public boolean isLeaseValid() {
        return this._lastLeaseUpdate.plus(this._leaseTime).isAfter(this._clock.instant());
    }

    public void updateLeaseTime() throws ChimeraNFSException {
        Instant curentTime = this._clock.instant();
        Duration delta = Duration.between(this._lastLeaseUpdate, curentTime);
        if (delta.compareTo(this._leaseTime) > 0) {
            throw new ExpiredException("lease time expired: (" + delta + "): " + BaseEncoding.base16().lowerCase().encode(this._ownerId) + " (" + this._clientId + ").");
        }
        this._lastLeaseUpdate = curentTime;
    }

    public void refreshLeaseTime() {
        this._lastLeaseUpdate = this._clock.instant();
    }

    public synchronized void reset() {
        this.refreshLeaseTime();
        this._isConfirmed = false;
    }

    public InetSocketAddress getRemoteAddress() {
        return this._clientAddress;
    }

    public InetSocketAddress getLocalAddress() {
        return this._localAddress;
    }

    public int currentSeqID() {
        return this._sessionSequence;
    }

    public NFS4State createState(StateOwner stateOwner, NFS4State openState) throws ChimeraNFSException {
        NFS4State state = new NFS4State(openState, stateOwner, this._stateHandler.createStateId(this, this._stateIdCounter.incrementAndGet()));
        if (openState != null) {
            openState.addDisposeListener(s2 -> {
                NFS4State nfsState = this._clientStates.get(state.stateid());
                if (nfsState != null) {
                    _log.debug("removing derived state {}", (Object)nfsState);
                    nfsState.tryDispose();
                }
                this._clientStates.remove(state.stateid());
            });
        }
        this._clientStates.put(state.stateid(), state);
        return state;
    }

    public NFS4State createState(StateOwner stateOwner) throws ChimeraNFSException {
        return this.createState(stateOwner, null);
    }

    public void releaseState(stateid4 stateid) throws ChimeraNFSException {
        NFS4State state = this._clientStates.get(stateid);
        if (state == null) {
            throw new BadStateidException("State not known to the client: " + stateid);
        }
        state.disposeIgnoreFailures();
        this._clientStates.remove(stateid);
    }

    public void tryReleaseState(stateid4 stateid) throws ChimeraNFSException {
        NFS4State state = this._clientStates.get(stateid);
        if (state == null) {
            throw new BadStateidException("State not known to the client: " + stateid);
        }
        state.tryDispose();
        this._clientStates.remove(stateid);
    }

    public NFS4State state(stateid4 stateid) throws ChimeraNFSException {
        NFS4State state = this._clientStates.get(stateid);
        if (state == null) {
            throw new BadStateidException("State not known to the client: " + stateid);
        }
        return state;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._clientAddress).append(":").append(BaseEncoding.base16().lowerCase().encode(this._ownerId)).append("@").append(this._clientId).append(":v4.").append(this.getMinorVersion());
        return sb.toString();
    }

    public Collection<NFSv41Session> sessions() {
        return this._sessions.values();
    }

    public synchronized NFSv41Session createSession(int sequence, int cacheSize, int cbCacheSize, int maxOps, int maxCbOps) throws ChimeraNFSException {
        _log.debug("session for sequience: {}", (Object)sequence);
        if (sequence > this._sessionSequence && this._isConfirmed) {
            throw new SeqMisorderedException("bad sequence id: " + this._sessionSequence + " / " + sequence);
        }
        if (sequence == this._sessionSequence - 1 && !this._isConfirmed) {
            throw new SeqMisorderedException("bad sequence id: " + this._sessionSequence + " / " + sequence);
        }
        if (sequence == this._sessionSequence - 1) {
            _log.debug("Retransmit on create session detected");
            sessionid4 sessionid = this._stateHandler.createSessionId(this, sequence);
            return this._sessions.get(sessionid);
        }
        if (sequence != this._sessionSequence) {
            throw new SeqMisorderedException("bad sequence id: " + this._sessionSequence + " / " + sequence);
        }
        sessionid4 sessionid = this._stateHandler.createSessionId(this, this._sessionSequence);
        NFSv41Session session = new NFSv41Session(this, sessionid, cacheSize, cbCacheSize, maxOps, maxCbOps);
        this._sessions.put(sessionid, session);
        ++this._sessionSequence;
        if (!this._isConfirmed) {
            this._isConfirmed = true;
            _log.debug("set client confirmed");
        }
        return session;
    }

    public synchronized void removeSession(sessionid4 id) throws BadSessionException {
        NFSv41Session session = this._sessions.remove(id);
        if (session == null) {
            throw new BadSessionException("session not found");
        }
    }

    public synchronized NFSv41Session getSession(sessionid4 id) throws BadSessionException {
        NFSv41Session session = this._sessions.get(id);
        if (session == null) {
            throw new BadSessionException("session not found");
        }
        return session;
    }

    public boolean hasSessions() {
        return !this._sessions.isEmpty();
    }

    public Principal principal() {
        return this._principal;
    }

    public boolean hasState() {
        return !this._clientStates.isEmpty();
    }

    public void attachState(NFS4State state) {
        this._clientStates.put(state.stateid(), state);
    }

    public void detachState(NFS4State state) {
        this._clientStates.remove(state.stateid());
    }

    private synchronized void drainStates() {
        Iterator<NFS4State> i = this._clientStates.values().iterator();
        while (i.hasNext()) {
            NFS4State state = i.next();
            state.disposeIgnoreFailures();
            i.remove();
        }
    }

    public final void tryDispose() {
        this.drainStates();
    }

    public synchronized void reclaimComplete() throws ChimeraNFSException {
        if (this._reclaim_completed) {
            throw new CompleteAlreadyException("Duplicating reclaim");
        }
        this._stateHandler.reclaimComplete(this.getOwnerId());
        this._reclaim_completed = true;
    }

    public synchronized void wantReclaim() throws ChimeraNFSException {
        if (this._reclaim_completed) {
            throw new NoGraceException("Already complete");
        }
        this._stateHandler.wantReclaim(this.getOwnerId());
    }

    public synchronized boolean needReclaim() {
        return !this._reclaim_completed;
    }

    public boolean isCallbackNeede() {
        return this._callbackNeeded;
    }

    public synchronized StateOwner getOrCreateOwner(byte[] owner, seqid4 seq) throws BadSeqidException {
        StateOwner stateOwner;
        if (this._minorVersion == 0) {
            Opaque k = new Opaque(owner);
            stateOwner = this._owners.get(k);
            if (stateOwner == null) {
                state_owner4 so = new state_owner4();
                so.clientid = this._clientId;
                so.owner = owner;
                stateOwner = new StateOwner(so, seq.value);
                this._owners.put(k, stateOwner);
            } else {
                stateOwner.acceptAsNextSequence(seq);
            }
        } else {
            state_owner4 so = new state_owner4();
            so.clientid = this._clientId;
            so.owner = owner;
            stateOwner = new StateOwner(so, 0);
        }
        return stateOwner;
    }

    public synchronized void releaseOwner(byte[] owner) throws StaleClientidException {
        Opaque k = new Opaque(owner);
        StateOwner stateOwner = this._owners.remove(k);
        if (stateOwner == null) {
            throw new StaleClientidException();
        }
    }
}

