/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import com.google.common.io.BaseEncoding;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.BadSlotException;
import org.dcache.nfs.v4.NFS4Client;
import org.dcache.nfs.v4.SessionConnection;
import org.dcache.nfs.v4.SessionSlot;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.sessionid4;

public class NFSv41Session {
    private final sessionid4 _session;
    private final SessionSlot[] _slots;
    private final NFS4Client _client;
    private final int _maxOps;
    private final int _maxCbOps;
    private final int _maxCbRequests;
    private final Set<SessionConnection> _boundConnections;

    public NFSv41Session(NFS4Client client, sessionid4 sessionid, int maxRequests, int maxCbRequests, int maxOps, int maxCbOps) {
        this._client = client;
        this._slots = new SessionSlot[maxRequests];
        this._session = sessionid;
        this._maxOps = maxOps;
        this._maxCbOps = maxCbOps;
        this._maxCbRequests = maxCbRequests;
        this._boundConnections = new HashSet<SessionConnection>();
    }

    public sessionid4 id() {
        return this._session;
    }

    public NFS4Client getClient() {
        return this._client;
    }

    public int getHighestSlot() {
        return this._slots.length - 1;
    }

    public int getCbHighestSlot() {
        return this._maxCbRequests - 1;
    }

    public int getHighestUsedSlot() {
        int id;
        for (id = this.getHighestSlot(); id >= 0 && this._slots[id] == null; --id) {
        }
        return id;
    }

    public List<nfs_resop4> checkCacheSlot(int slot, int sequence) throws ChimeraNFSException {
        return this.getSessionSlot(slot).acquire(sequence);
    }

    public SessionSlot getSessionSlot(int slot) throws ChimeraNFSException {
        if (slot < 0 || slot > this.getHighestSlot()) {
            throw new BadSlotException("slot id overflow");
        }
        if (this._slots[slot] == null) {
            this._slots[slot] = new SessionSlot();
        }
        return this._slots[slot];
    }

    public int getMaxOps() {
        return this._maxOps;
    }

    public int getMaxCbOps() {
        return this._maxCbOps;
    }

    public String toString() {
        return this._client.getRemoteAddress() + " : " + BaseEncoding.base16().lowerCase().encode(this._session.value);
    }

    public synchronized void bindIfNeeded(SessionConnection connection) {
        if (this._boundConnections.isEmpty()) {
            this.bindToConnection(connection);
        }
    }

    public synchronized void bindToConnection(SessionConnection connection) {
        this._boundConnections.add(connection);
    }

    public synchronized boolean isReleasableBy(SessionConnection connection) {
        return this._boundConnections.isEmpty() || this._boundConnections.contains(connection);
    }
}

