/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.dcache.nfs.status.BadXdrException;
import org.dcache.nfs.status.ServerFaultException;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.LayoutDriver;
import org.dcache.nfs.v4.xdr.device_addr4;
import org.dcache.nfs.v4.xdr.deviceid4;
import org.dcache.nfs.v4.xdr.layout_content4;
import org.dcache.nfs.v4.xdr.layouttype4;
import org.dcache.nfs.v4.xdr.multipath_list4;
import org.dcache.nfs.v4.xdr.netaddr4;
import org.dcache.nfs.v4.xdr.nfl_util4;
import org.dcache.nfs.v4.xdr.nfs_fh4;
import org.dcache.nfs.v4.xdr.nfsv4_1_file_layout4;
import org.dcache.nfs.v4.xdr.nfsv4_1_file_layout_ds_addr4;
import org.dcache.nfs.v4.xdr.offset4;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.nfs.v4.xdr.uint32_t;
import org.dcache.oncrpc4j.xdr.Xdr;

public class NfsV41FileLayoutDriver
implements LayoutDriver {
    @Override
    public layouttype4 getLayoutType() {
        return layouttype4.LAYOUT4_NFSV4_1_FILES;
    }

    @Override
    public device_addr4 getDeviceAddress(InetSocketAddress ... deviceAddress) {
        nfsv4_1_file_layout_ds_addr4 file_type = new nfsv4_1_file_layout_ds_addr4();
        file_type.nflda_multipath_ds_list = new multipath_list4[1];
        file_type.nflda_multipath_ds_list[0] = new multipath_list4();
        file_type.nflda_multipath_ds_list[0].value = new netaddr4[deviceAddress.length];
        for (int i = 0; i < deviceAddress.length; ++i) {
            file_type.nflda_multipath_ds_list[0].value[i] = new netaddr4(deviceAddress[i]);
        }
        file_type.nflda_stripe_indices = new uint32_t[1];
        file_type.nflda_stripe_indices[0] = new uint32_t(0);
        Xdr xdr = new Xdr(128);
        try {
            xdr.beginEncoding();
            file_type.xdrEncode(xdr);
            xdr.endEncoding();
            device_addr4 addr = new device_addr4();
            addr.da_layout_type = layouttype4.LAYOUT4_NFSV4_1_FILES.getValue();
            addr.da_addr_body = xdr.getBytes();
            device_addr4 device_addr42 = addr;
            xdr.close();
            return device_addr42;
        }
        catch (Throwable throwable) {
            try {
                try {
                    xdr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected IOException:", e);
            }
        }
    }

    @Override
    public layout_content4 getLayoutContent(stateid4 stateid, int stripeSize, nfs_fh4 fh, deviceid4 ... deviceids) throws ServerFaultException {
        Preconditions.checkArgument(deviceids.length == 1, "Layout driver supports only one (1) device.");
        nfsv4_1_file_layout4 layout = new nfsv4_1_file_layout4();
        layout.nfl_deviceid = deviceids[0];
        layout.nfl_fh_list = new nfs_fh4[1];
        layout.nfl_fh_list[0] = fh;
        layout.nfl_first_stripe_index = new uint32_t(0);
        layout.nfl_util = new nfl_util4(stripeSize & 0xFFFFFFC0);
        layout.nfl_pattern_offset = new offset4(0L);
        Xdr xdr = new Xdr(512);
        try {
            xdr.beginEncoding();
            layout.xdrEncode(xdr);
            xdr.endEncoding();
            layout_content4 content = new layout_content4();
            content.loc_type = layouttype4.LAYOUT4_NFSV4_1_FILES.getValue();
            content.loc_body = xdr.getBytes();
            layout_content4 layout_content42 = content;
            xdr.close();
            return layout_content42;
        }
        catch (Throwable throwable) {
            try {
                try {
                    xdr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ServerFaultException("failed to encode layout body");
            }
        }
    }

    @Override
    public void acceptLayoutReturnData(CompoundContext context, byte[] data) throws BadXdrException {
        if (data.length != 0) {
            throw new BadXdrException("Unexpected data on layout return from: " + context.getRemoteSocketAddress().getAddress().getHostAddress());
        }
    }
}

