/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.xdr.COMMIT4res;
import org.dcache.nfs.v4.xdr.COMMIT4resok;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.vfs.Inode;

public class OperationCOMMIT
extends AbstractNFSv4Operation {
    public OperationCOMMIT(nfs_argop4 args) {
        super(args, 5);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException {
        COMMIT4res res = result.opcommit;
        Inode inode = context.currentInode();
        this._args.opcommit.offset.checkOverflow(this._args.opcommit.count.value, "offset + length overflow");
        context.getFs().commit(inode, this._args.opcommit.offset.value, this._args.opcommit.count.value);
        res.resok4 = new COMMIT4resok();
        res.resok4.writeverf = context.getRebootVerifier();
        result.opcommit.status = 0;
    }
}

