/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import com.google.common.annotations.Beta;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.NotSuppException;
import org.dcache.nfs.status.OpenModeException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NFS4Client;
import org.dcache.nfs.v4.NFS4State;
import org.dcache.nfs.v4.xdr.COPY4res;
import org.dcache.nfs.v4.xdr.COPY4resok;
import org.dcache.nfs.v4.xdr.copy_requirements4;
import org.dcache.nfs.v4.xdr.length4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_fh4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.nfs.v4.xdr.verifier4;
import org.dcache.nfs.v4.xdr.write_response4;
import org.dcache.nfs.vfs.Inode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class OperationCOPY
extends AbstractNFSv4Operation {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationCOPY.class);

    public OperationCOPY(nfs_argop4 args) {
        super(args, 60);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException {
        COPY4res res = result.opcopy;
        if (this._args.opcopy.ca_source_server.length > 0) {
            throw new NotSuppException("Inter-server copy is not supported");
        }
        if (!this._args.opcopy.ca_consecutive) {
            res.cr_requirements = new copy_requirements4();
            res.cr_requirements.cr_consecutive = true;
            res.cr_requirements.cr_synchronous = this._args.opcopy.ca_synchronous;
            res.cr_status = 10094;
            return;
        }
        Inode srcInode = context.savedInode();
        Inode dstInode = context.currentInode();
        long srcPos = this._args.opcopy.ca_src_offset.value;
        long dstPos = this._args.opcopy.ca_dst_offset.value;
        long len = this._args.opcopy.ca_count.value;
        NFS4Client client = context.getSession().getClient();
        NFS4State srcState = client.state(this._args.opcopy.ca_src_stateid);
        NFS4State dstState = client.state(this._args.opcopy.ca_dst_stateid);
        int srcAccess = context.getStateHandler().getFileTracker().getShareAccess(client, srcInode, srcState.getOpenState().stateid());
        int dstAccess = context.getStateHandler().getFileTracker().getShareAccess(client, dstInode, dstState.getOpenState().stateid());
        if ((srcAccess & 1) == 0) {
            throw new OpenModeException("Invalid source inode open mode (required read)");
        }
        if ((dstAccess & 2) == 0) {
            throw new OpenModeException("Invalid destination inode open mode (required write)");
        }
        res.cr_resok4 = new COPY4resok();
        res.cr_resok4.cr_response = new write_response4();
        res.cr_resok4.cr_response.wr_writeverf = context.getRebootVerifier();
        res.cr_resok4.cr_response.wr_callback_id = new stateid4[0];
        res.cr_resok4.cr_response.wr_committed = 2;
        res.cr_resok4.cr_response.wr_count = new length4(0L);
        res.cr_resok4.cr_requirements = new copy_requirements4();
        res.cr_resok4.cr_requirements.cr_consecutive = true;
        res.cr_status = 0;
        CompletableFuture<Long> copyFuture = context.getFs().copyFileRange(srcInode, srcPos, dstInode, dstPos, len);
        boolean isSync = this._args.opcopy.ca_synchronous;
        if (isSync) {
            try {
                long n = copyFuture.get(1L, TimeUnit.SECONDS);
                res.cr_resok4.cr_response.wr_count = new length4(n);
            }
            catch (InterruptedException | ExecutionException e) {
                Throwable cause = Throwables.getRootCause(e);
                Throwables.propagateIfPossible(cause, ChimeraNFSException.class);
                LOGGER.error("Copy-offload failed: {}", (Object)e.getMessage());
                res.cr_status = 5;
            }
            catch (TimeoutException e) {
                isSync = false;
            }
        }
        if (!isSync) {
            stateid4 copyState = this.notifyWhenComplete(client, dstInode, context.getRebootVerifier(), copyFuture);
            res.cr_resok4.cr_response.wr_callback_id = new stateid4[]{copyState};
        }
        res.cr_resok4.cr_requirements.cr_synchronous = isSync;
    }

    private stateid4 notifyWhenComplete(NFS4Client client, Inode dstInode, verifier4 verifier, CompletableFuture<Long> copyFuture) throws ChimeraNFSException {
        NFS4State openState = client.state(this._args.opcopy.ca_src_stateid);
        stateid4 copyState = client.createState(openState.getStateOwner(), openState).stateid();
        copyFuture.handle((n, t2) -> {
            write_response4 cr_response = new write_response4();
            cr_response.wr_callback_id = new stateid4[0];
            cr_response.wr_committed = 2;
            cr_response.wr_count = new length4((long)n);
            cr_response.wr_writeverf = verifier;
            try {
                client.getCB().cbOffload(new nfs_fh4(dstInode.toNfsHandle()), copyState, cr_response, this.toNfsState((Throwable)t2));
            }
            catch (IOException ex) {
                LOGGER.warn("Failed to notify client about copy-offload completion: {}", (Object)ex.getMessage());
            }
            return null;
        });
        return copyState;
    }

    private int toNfsState(Throwable t2) {
        if (t2 == null) {
            return 0;
        }
        LOGGER.warn("Copy-offload failed with exception: {}", (Object)Throwables.getRootCause(t2).toString());
        return 5;
    }
}

