/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.dcache.nfs.status.AccessException;
import org.dcache.nfs.status.InvalException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NFSv41DeviceManager;
import org.dcache.nfs.v4.NFSv4FileAttributes;
import org.dcache.nfs.v4.xdr.GETATTR4res;
import org.dcache.nfs.v4.xdr.GETATTR4resok;
import org.dcache.nfs.v4.xdr.attrlist4;
import org.dcache.nfs.v4.xdr.bitmap4;
import org.dcache.nfs.v4.xdr.fattr4;
import org.dcache.nfs.v4.xdr.fattr4_acl;
import org.dcache.nfs.v4.xdr.fattr4_aclsupport;
import org.dcache.nfs.v4.xdr.fattr4_cansettime;
import org.dcache.nfs.v4.xdr.fattr4_case_insensitive;
import org.dcache.nfs.v4.xdr.fattr4_case_preserving;
import org.dcache.nfs.v4.xdr.fattr4_change;
import org.dcache.nfs.v4.xdr.fattr4_fh_expire_type;
import org.dcache.nfs.v4.xdr.fattr4_filehandle;
import org.dcache.nfs.v4.xdr.fattr4_fileid;
import org.dcache.nfs.v4.xdr.fattr4_files_avail;
import org.dcache.nfs.v4.xdr.fattr4_files_free;
import org.dcache.nfs.v4.xdr.fattr4_files_total;
import org.dcache.nfs.v4.xdr.fattr4_fs_layout_types;
import org.dcache.nfs.v4.xdr.fattr4_fsid;
import org.dcache.nfs.v4.xdr.fattr4_homogeneous;
import org.dcache.nfs.v4.xdr.fattr4_lease_time;
import org.dcache.nfs.v4.xdr.fattr4_link_support;
import org.dcache.nfs.v4.xdr.fattr4_maxfilesize;
import org.dcache.nfs.v4.xdr.fattr4_maxlink;
import org.dcache.nfs.v4.xdr.fattr4_maxname;
import org.dcache.nfs.v4.xdr.fattr4_maxread;
import org.dcache.nfs.v4.xdr.fattr4_maxwrite;
import org.dcache.nfs.v4.xdr.fattr4_mode;
import org.dcache.nfs.v4.xdr.fattr4_mounted_on_fileid;
import org.dcache.nfs.v4.xdr.fattr4_named_attr;
import org.dcache.nfs.v4.xdr.fattr4_no_trunc;
import org.dcache.nfs.v4.xdr.fattr4_numlinks;
import org.dcache.nfs.v4.xdr.fattr4_owner;
import org.dcache.nfs.v4.xdr.fattr4_rawdev;
import org.dcache.nfs.v4.xdr.fattr4_size;
import org.dcache.nfs.v4.xdr.fattr4_space_avail;
import org.dcache.nfs.v4.xdr.fattr4_space_free;
import org.dcache.nfs.v4.xdr.fattr4_space_total;
import org.dcache.nfs.v4.xdr.fattr4_space_used;
import org.dcache.nfs.v4.xdr.fattr4_supported_attrs;
import org.dcache.nfs.v4.xdr.fattr4_symlink_support;
import org.dcache.nfs.v4.xdr.fattr4_time_access;
import org.dcache.nfs.v4.xdr.fattr4_time_create;
import org.dcache.nfs.v4.xdr.fattr4_time_delta;
import org.dcache.nfs.v4.xdr.fattr4_time_metadata;
import org.dcache.nfs.v4.xdr.fattr4_time_modify;
import org.dcache.nfs.v4.xdr.fattr4_type;
import org.dcache.nfs.v4.xdr.fattr4_unique_handles;
import org.dcache.nfs.v4.xdr.fattr4_xattr_support;
import org.dcache.nfs.v4.xdr.fsid4;
import org.dcache.nfs.v4.xdr.layouttype4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_fh4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.nfsace4;
import org.dcache.nfs.v4.xdr.nfstime4;
import org.dcache.nfs.v4.xdr.specdata4;
import org.dcache.nfs.v4.xdr.uint64_t;
import org.dcache.nfs.v4.xdr.utf8str_mixed;
import org.dcache.nfs.vfs.FsStat;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.nfs.vfs.VirtualFileSystem;
import org.dcache.oncrpc4j.rpc.OncRpcException;
import org.dcache.oncrpc4j.xdr.Xdr;
import org.dcache.oncrpc4j.xdr.XdrAble;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationGETATTR
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationGETATTR.class);

    public OperationGETATTR(nfs_argop4 args) {
        super(args, 9);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws IOException, OncRpcException {
        GETATTR4res res = result.opgetattr;
        res.resok4 = new GETATTR4resok();
        res.resok4.obj_attributes = OperationGETATTR.getAttributes(this._args.opgetattr.attr_request, context.getFs(), context.currentInode(), context);
        res.status = 0;
    }

    static fattr4 getAttributes(bitmap4 bitmap, VirtualFileSystem fs, Inode inode, Stat stat, CompoundContext context) throws IOException, OncRpcException {
        byte[] retBytes;
        bitmap4 processedAttributes = new bitmap4(new int[0]);
        try (Xdr xdr = new Xdr(1024);){
            xdr.beginEncoding();
            for (int i : bitmap) {
                Optional<? extends XdrAble> optionalAttr = OperationGETATTR.fattr2xdr(i, fs, inode, stat, context);
                if (optionalAttr.isPresent()) {
                    XdrAble attr = optionalAttr.get();
                    _log.debug("   getAttributes : {} ({}) OK.", (Object)i, (Object)OperationGETATTR.attrMask2String(i));
                    attr.xdrEncode(xdr);
                    processedAttributes.set(i);
                    continue;
                }
                _log.debug("   getAttributes : {} ({}) NOT SUPPORTED.", (Object)i, (Object)OperationGETATTR.attrMask2String(i));
            }
            xdr.endEncoding();
            retBytes = xdr.getBytes();
        }
        fattr4 attributes = new fattr4();
        attributes.attrmask = processedAttributes;
        attributes.attr_vals = new attrlist4(retBytes);
        return attributes;
    }

    static fattr4 getAttributes(bitmap4 bitmap, VirtualFileSystem fs, Inode inode, CompoundContext context) throws IOException, OncRpcException {
        return OperationGETATTR.getAttributes(bitmap, fs, inode, context.getFs().getattr(inode), context);
    }

    private static FsStat getFsStat(FsStat fsStat, VirtualFileSystem fs) throws IOException {
        if (fsStat != null) {
            return fsStat;
        }
        return fs.getFsStat();
    }

    static Optional<? extends XdrAble> fattr2xdr(int fattr, VirtualFileSystem fs, Inode inode, Stat stat, CompoundContext context) throws IOException {
        FsStat fsStat = null;
        switch (fattr) {
            case 0: {
                int[] bitmap = context.getMinorversion() == 0 ? NFSv4FileAttributes.SUPPORTED_ATTRS_V4_0 : (context.getDeviceManager().isPresent() ? NFSv4FileAttributes.SUPPORTED_ATTRS_V4_1 : NFSv4FileAttributes.SUPPORTED_ATTRS_V4_1_NO_PNFS);
                return Optional.of(new fattr4_supported_attrs(bitmap));
            }
            case 1: {
                fattr4_type type = new fattr4_type(OperationGETATTR.unixType2NFS(stat.getMode()));
                return Optional.of(type);
            }
            case 2: {
                fattr4_fh_expire_type fh_expire_type = new fattr4_fh_expire_type(0);
                return Optional.of(fh_expire_type);
            }
            case 3: {
                fattr4_change change = new fattr4_change(stat.getGeneration());
                return Optional.of(change);
            }
            case 4: {
                fattr4_size size = new fattr4_size(stat.getSize());
                return Optional.of(size);
            }
            case 5: {
                fattr4_link_support link_support = new fattr4_link_support(true);
                return Optional.of(link_support);
            }
            case 6: {
                fattr4_symlink_support symlink_support = new fattr4_symlink_support(true);
                return Optional.of(symlink_support);
            }
            case 7: {
                fattr4_named_attr named_attr = new fattr4_named_attr(false);
                return Optional.of(named_attr);
            }
            case 8: {
                fsid4 fsid = new fsid4();
                fsid.major = new uint64_t(17L);
                fsid.minor = new uint64_t(17L);
                return Optional.of(new fattr4_fsid(fsid));
            }
            case 9: {
                return Optional.of(new fattr4_unique_handles(true));
            }
            case 10: {
                return Optional.of(new fattr4_lease_time((int)context.getStateHandler().getLeaseTime().toSeconds()));
            }
            case 11: {
                return Optional.empty();
            }
            case 19: {
                nfs_fh4 fh = new nfs_fh4();
                fh.value = inode.toNfsHandle();
                return Optional.of(new fattr4_filehandle(fh));
            }
            case 12: {
                nfsace4[] aces = context.getFs().getAcl(inode);
                return Optional.of(new fattr4_acl(aces));
            }
            case 13: {
                fattr4_aclsupport aclSupport = new fattr4_aclsupport(3);
                return Optional.of(aclSupport);
            }
            case 14: {
                return Optional.empty();
            }
            case 15: {
                return Optional.of(new fattr4_cansettime(true));
            }
            case 16: {
                return Optional.of(new fattr4_case_insensitive(fs.getCaseInsensitive()));
            }
            case 17: {
                return Optional.of(new fattr4_case_preserving(fs.getCasePreserving()));
            }
            case 18: {
                return Optional.empty();
            }
            case 20: {
                return Optional.of(new fattr4_fileid(stat.getIno()));
            }
            case 21: {
                fsStat = OperationGETATTR.getFsStat(fsStat, fs);
                fattr4_files_avail files_avail = new fattr4_files_avail(fsStat.getTotalFiles() - fsStat.getUsedFiles());
                return Optional.of(files_avail);
            }
            case 22: {
                fsStat = OperationGETATTR.getFsStat(fsStat, fs);
                fattr4_files_free files_free = new fattr4_files_free(fsStat.getTotalFiles() - fsStat.getUsedFiles());
                return Optional.of(files_free);
            }
            case 23: {
                fsStat = OperationGETATTR.getFsStat(fsStat, fs);
                return Optional.of(new fattr4_files_total(fsStat.getTotalFiles()));
            }
            case 24: {
                return Optional.empty();
            }
            case 25: {
                return Optional.empty();
            }
            case 26: {
                return Optional.of(new fattr4_homogeneous(true));
            }
            case 27: {
                return Optional.of(new fattr4_maxfilesize(Long.MAX_VALUE));
            }
            case 28: {
                return Optional.of(new fattr4_maxlink(255));
            }
            case 29: {
                return Optional.of(new fattr4_maxname(255));
            }
            case 30: {
                return Optional.of(new fattr4_maxread(0x400000L));
            }
            case 31: {
                fattr4_maxwrite maxwrite = new fattr4_maxwrite(0x400000L);
                return Optional.of(maxwrite);
            }
            case 32: {
                return Optional.empty();
            }
            case 33: {
                return Optional.of(new fattr4_mode(stat.getMode() & 0xFFF));
            }
            case 34: {
                return Optional.of(new fattr4_no_trunc(true));
            }
            case 35: {
                return Optional.of(new fattr4_numlinks(stat.getNlink()));
            }
            case 36: {
                String owner_s = context.getFs().getIdMapper().uidToPrincipal(stat.getUid());
                utf8str_mixed user = new utf8str_mixed(owner_s);
                return Optional.of(new fattr4_owner(user));
            }
            case 37: {
                String group_s = context.getFs().getIdMapper().gidToPrincipal(stat.getGid());
                utf8str_mixed group = new utf8str_mixed(group_s);
                return Optional.of(new fattr4_owner(group));
            }
            case 38: {
                return Optional.empty();
            }
            case 39: {
                return Optional.empty();
            }
            case 40: {
                return Optional.empty();
            }
            case 41: {
                specdata4 dev = new specdata4();
                dev.specdata1 = 0;
                dev.specdata2 = 0;
                return Optional.of(new fattr4_rawdev(dev));
            }
            case 42: {
                fsStat = OperationGETATTR.getFsStat(fsStat, fs);
                fattr4_space_avail spaceAvail = new fattr4_space_avail(fsStat.getTotalSpace() - fsStat.getUsedSpace());
                return Optional.of(spaceAvail);
            }
            case 43: {
                fsStat = OperationGETATTR.getFsStat(fsStat, fs);
                fattr4_space_free space_free = new fattr4_space_free(fsStat.getTotalSpace() - fsStat.getUsedSpace());
                return Optional.of(space_free);
            }
            case 44: {
                fsStat = OperationGETATTR.getFsStat(fsStat, fs);
                return Optional.of(new fattr4_space_total(fsStat.getTotalSpace()));
            }
            case 45: {
                return Optional.of(new fattr4_space_used(stat.getSize()));
            }
            case 46: {
                return Optional.empty();
            }
            case 47: {
                fattr4_time_access atime = new fattr4_time_access(stat.getATime());
                return Optional.of(atime);
            }
            case 49: {
                return Optional.empty();
            }
            case 50: {
                long btimeMillis = stat.isDefined(Stat.StatAttribute.BTIME) ? stat.getBTime() : stat.getCTime();
                fattr4_time_create btime = new fattr4_time_create(btimeMillis);
                return Optional.of(btime);
            }
            case 51: {
                return Optional.of(new fattr4_time_delta(new nfstime4(TimeUnit.SECONDS.toMillis(1L))));
            }
            case 52: {
                fattr4_time_metadata mdtime = new fattr4_time_metadata(stat.getCTime());
                return Optional.of(mdtime);
            }
            case 53: {
                fattr4_time_modify mtime = new fattr4_time_modify(stat.getMTime());
                return Optional.of(mtime);
            }
            case 55: {
                long mofi = stat.getIno();
                if (mofi == 11575866L) {
                    mofi = 305419896L;
                }
                fattr4_mounted_on_fileid mounted_on_fileid = new fattr4_mounted_on_fileid(mofi);
                return Optional.of(mounted_on_fileid);
            }
            case 62: {
                fattr4_fs_layout_types fs_layout_type = new fattr4_fs_layout_types();
                Optional<NFSv41DeviceManager> pnfsDeviceManager = context.getDeviceManager();
                if (!pnfsDeviceManager.isPresent()) {
                    return Optional.empty();
                }
                List<layouttype4> exportLayouts = context.getExportTable().exports(context.getRemoteSocketAddress().getAddress()).findFirst().orElseThrow(AccessException::new).getLayoutTypes();
                Set<layouttype4> supportedLayouts = pnfsDeviceManager.get().getLayoutTypes();
                fs_layout_type.value = exportLayouts.isEmpty() ? supportedLayouts.stream().mapToInt(layouttype4::getValue).toArray() : exportLayouts.stream().filter(e -> supportedLayouts.contains(e)).mapToInt(layouttype4::getValue).toArray();
                return Optional.of(fs_layout_type);
            }
            case 75: {
                return Optional.of(new fattr4_supported_attrs(NFSv4FileAttributes.EXCLCREAT_ATTR));
            }
            case 82: {
                return Optional.of(new fattr4_xattr_support(true));
            }
            case 48: 
            case 54: {
                throw new InvalException("getattr of write-only attributes");
            }
        }
        _log.debug("GETATTR for #{}", (Object)fattr);
        return Optional.empty();
    }

    public static String attrMask2String(int offset) {
        Object maskName = "Unknown";
        switch (offset) {
            case 0: {
                maskName = "FATTR4_SUPPORTED_ATTRS";
                break;
            }
            case 1: {
                maskName = "FATTR4_TYPE";
                break;
            }
            case 2: {
                maskName = "FATTR4_FH_EXPIRE_TYPE";
                break;
            }
            case 3: {
                maskName = "FATTR4_CHANGE";
                break;
            }
            case 4: {
                maskName = "FATTR4_SIZE";
                break;
            }
            case 5: {
                maskName = "FATTR4_LINK_SUPPORT";
                break;
            }
            case 6: {
                maskName = "FATTR4_SYMLINK_SUPPORT";
                break;
            }
            case 7: {
                maskName = "FATTR4_NAMED_ATTR";
                break;
            }
            case 8: {
                maskName = "FATTR4_FSID";
                break;
            }
            case 9: {
                maskName = "FATTR4_UNIQUE_HANDLES";
                break;
            }
            case 10: {
                maskName = "FATTR4_LEASE_TIME";
                break;
            }
            case 11: {
                maskName = "FATTR4_RDATTR_ERROR";
                break;
            }
            case 19: {
                maskName = "FATTR4_FILEHANDLE";
                break;
            }
            case 12: {
                maskName = "FATTR4_ACL";
                break;
            }
            case 13: {
                maskName = "FATTR4_ACLSUPPORT";
                break;
            }
            case 14: {
                maskName = "FATTR4_ARCHIVE";
                break;
            }
            case 15: {
                maskName = "FATTR4_CANSETTIME";
                break;
            }
            case 16: {
                maskName = "FATTR4_CASE_INSENSITIVE";
                break;
            }
            case 17: {
                maskName = "FATTR4_CASE_PRESERVING";
                break;
            }
            case 18: {
                maskName = "FATTR4_CHOWN_RESTRICTED";
                break;
            }
            case 20: {
                maskName = "FATTR4_FILEID";
                break;
            }
            case 21: {
                maskName = "FATTR4_FILES_AVAIL";
                break;
            }
            case 22: {
                maskName = "FATTR4_FILES_FREE";
                break;
            }
            case 23: {
                maskName = "FATTR4_FILES_TOTAL";
                break;
            }
            case 24: {
                maskName = "FATTR4_FS_LOCATIONS";
                break;
            }
            case 25: {
                maskName = "FATTR4_HIDDEN";
                break;
            }
            case 26: {
                maskName = "FATTR4_HOMOGENEOUS";
                break;
            }
            case 27: {
                maskName = "FATTR4_MAXFILESIZE";
                break;
            }
            case 28: {
                maskName = "FATTR4_MAXLINK";
                break;
            }
            case 29: {
                maskName = "FATTR4_MAXNAME";
                break;
            }
            case 30: {
                maskName = "FATTR4_MAXREAD";
                break;
            }
            case 31: {
                maskName = "FATTR4_MAXWRITE";
                break;
            }
            case 32: {
                maskName = "FATTR4_MIMETYPE";
                break;
            }
            case 33: {
                maskName = "FATTR4_MODE";
                break;
            }
            case 34: {
                maskName = "FATTR4_NO_TRUNC";
                break;
            }
            case 35: {
                maskName = "FATTR4_NUMLINKS";
                break;
            }
            case 36: {
                maskName = "FATTR4_OWNER";
                break;
            }
            case 37: {
                maskName = "FATTR4_OWNER_GROUP";
                break;
            }
            case 38: {
                maskName = "FATTR4_QUOTA_AVAIL_HARD";
                break;
            }
            case 39: {
                maskName = "FATTR4_QUOTA_AVAIL_SOFT";
                break;
            }
            case 40: {
                maskName = "FATTR4_QUOTA_USED";
                break;
            }
            case 41: {
                maskName = "FATTR4_RAWDEV";
                break;
            }
            case 42: {
                maskName = "FATTR4_SPACE_AVAIL";
                break;
            }
            case 43: {
                maskName = "FATTR4_SPACE_FREE";
                break;
            }
            case 44: {
                maskName = "FATTR4_SPACE_TOTAL";
                break;
            }
            case 45: {
                maskName = "FATTR4_SPACE_USED";
                break;
            }
            case 46: {
                maskName = "FATTR4_SYSTEM";
                break;
            }
            case 47: {
                maskName = "FATTR4_TIME_ACCESS";
                break;
            }
            case 48: {
                maskName = "FATTR4_TIME_ACCESS_SET";
                break;
            }
            case 49: {
                maskName = "FATTR4_TIME_BACKUP";
                break;
            }
            case 50: {
                maskName = "FATTR4_TIME_CREATE";
                break;
            }
            case 51: {
                maskName = "FATTR4_TIME_DELTA";
                break;
            }
            case 52: {
                maskName = "FATTR4_TIME_METADATA";
                break;
            }
            case 53: {
                maskName = "FATTR4_TIME_MODIFY";
                break;
            }
            case 54: {
                maskName = "FATTR4_TIME_MODIFY_SET";
                break;
            }
            case 55: {
                maskName = "FATTR4_MOUNTED_ON_FILEID";
                break;
            }
            case 62: {
                maskName = "FATTR4_FS_LAYOUT_TYPE";
                break;
            }
            case 63: {
                maskName = "FATTR4_LAYOUT_HINT";
                break;
            }
            case 64: {
                maskName = "FATTR4_LAYOUT_TYPE";
                break;
            }
            case 65: {
                maskName = "FATTR4_LAYOUT_BLKSIZE";
                break;
            }
            case 66: {
                maskName = "FATTR4_LAYOUT_ALIGNMENT";
                break;
            }
            case 67: {
                maskName = "FATTR4_FS_LOCATIONS_INFO";
                break;
            }
            case 68: {
                maskName = "FATTR4_MDSTHRESHOLD";
                break;
            }
            case 69: {
                maskName = "FATTR4_RETENTION_GET";
                break;
            }
            case 70: {
                maskName = "FATTR4_RETENTION_SET";
                break;
            }
            case 71: {
                maskName = "FATTR4_RETENTEVT_GET";
                break;
            }
            case 72: {
                maskName = "FATTR4_RETENTEVT_SET";
                break;
            }
            case 73: {
                maskName = "FATTR4_RETENTION_HOLD";
                break;
            }
            case 74: {
                maskName = "FATTR4_MODE_SET_MASKED";
                break;
            }
            case 76: {
                maskName = "FATTR4_FS_CHARSET_CAP";
                break;
            }
            case 75: {
                maskName = "FATTR4_SUPPATTR_EXCLCREAT";
                break;
            }
            default: {
                maskName = (String)maskName + "(" + offset + ")";
            }
        }
        return maskName;
    }

    static int unixType2NFS(int type) {
        int ret = 0;
        int mask = 258048;
        switch (type & mask) {
            case 32768: {
                ret = 1;
                break;
            }
            case 16384: {
                ret = 2;
                break;
            }
            case 40960: {
                ret = 5;
                break;
            }
            case 49152: {
                ret = 6;
                break;
            }
            case 24576: {
                ret = 3;
                break;
            }
            case 8192: {
                ret = 4;
                break;
            }
            case 4096: {
                ret = 7;
                break;
            }
            default: {
                _log.info("Unknown mode [{}]", (Object)Integer.toOctalString(type));
                ret = 0;
            }
        }
        return ret;
    }
}

