/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import java.util.List;
import org.dcache.nfs.status.InvalException;
import org.dcache.nfs.status.NotSuppException;
import org.dcache.nfs.status.TooSmallException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NFSv41DeviceManager;
import org.dcache.nfs.v4.xdr.GETDEVICELIST4res;
import org.dcache.nfs.v4.xdr.GETDEVICELIST4resok;
import org.dcache.nfs.v4.xdr.deviceid4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_cookie4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.verifier4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationGETDEVICELIST
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationGETDEVICELIST.class);

    public OperationGETDEVICELIST(nfs_argop4 args) {
        super(args, 48);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws IOException {
        GETDEVICELIST4res res = result.opgetdevicelist;
        NFSv41DeviceManager pnfsDeviceManager = context.getDeviceManager().orElseThrow(() -> new NotSuppException("pNFS device manager not configured"));
        if (this._args.opgetdevicelist.gdla_maxdevices.value < 0) {
            throw new InvalException("negative maxcount");
        }
        if (this._args.opgetdevicelist.gdla_maxdevices.value < 1) {
            throw new TooSmallException("device list too small");
        }
        res.gdlr_resok4 = new GETDEVICELIST4resok();
        res.gdlr_resok4.gdlr_cookie = new nfs_cookie4(1L);
        res.gdlr_resok4.gdlr_cookieverf = new verifier4();
        res.gdlr_resok4.gdlr_cookieverf.value = new byte[8];
        List<deviceid4> deviceIDs = pnfsDeviceManager.getDeviceList(context, this._args.opgetdevicelist);
        int deviceListSize = Math.min(deviceIDs.size(), this._args.opgetdevicelist.gdla_maxdevices.value);
        res.gdlr_resok4.gdlr_deviceid_list = new deviceid4[deviceListSize];
        for (int i = 0; i < deviceListSize; ++i) {
            deviceid4 deviceId;
            res.gdlr_resok4.gdlr_deviceid_list[i] = deviceId = deviceIDs.get(i);
        }
        _log.debug("GETDEVICELIST4: new list of #{}, maxcount {}", (Object)res.gdlr_resok4.gdlr_deviceid_list.length, (Object)this._args.opgetdevicelist.gdla_maxdevices.value);
        res.gdlr_resok4.gdlr_eof = true;
        res.gdlr_status = 0;
    }
}

