/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import java.util.OptionalLong;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.BadLayoutException;
import org.dcache.nfs.status.NotSuppException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NFS4Client;
import org.dcache.nfs.v4.NFS4State;
import org.dcache.nfs.v4.NFSv41DeviceManager;
import org.dcache.nfs.v4.Stateids;
import org.dcache.nfs.v4.xdr.LAYOUTCOMMIT4res;
import org.dcache.nfs.v4.xdr.LAYOUTCOMMIT4resok;
import org.dcache.nfs.v4.xdr.length4;
import org.dcache.nfs.v4.xdr.newsize4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.nfs.vfs.Inode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationLAYOUTCOMMIT
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationLAYOUTCOMMIT.class);

    public OperationLAYOUTCOMMIT(nfs_argop4 args) {
        super(args, 49);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException {
        LAYOUTCOMMIT4res res = result.oplayoutcommit;
        NFSv41DeviceManager pnfsDeviceManager = context.getDeviceManager().orElseThrow(() -> new NotSuppException("pNFS device manager not configured"));
        Inode inode = context.currentInode();
        NFS4Client client = context.getSession().getClient();
        stateid4 stateid = Stateids.getCurrentStateidIfNeeded(context, this._args.oplayoutcommit.loca_stateid);
        NFS4State state = client.state(stateid);
        int shareAccess = context.getStateHandler().getFileTracker().getShareAccess(client, inode, state.getOpenState().stateid());
        if ((shareAccess & 2) == 0) {
            throw new BadLayoutException("Invalid open mode");
        }
        _log.debug("LAYOUTCOMMIT: inode={} length={} offset={} loca_last_write_offset={}", inode, this._args.oplayoutcommit.loca_length.value, this._args.oplayoutcommit.loca_offset.value, this._args.oplayoutcommit.loca_last_write_offset.no_newoffset ? Long.valueOf(this._args.oplayoutcommit.loca_last_write_offset.no_offset.value) : "notset");
        res.locr_resok4 = new LAYOUTCOMMIT4resok();
        res.locr_resok4.locr_newsize = new newsize4();
        OptionalLong newSize = pnfsDeviceManager.layoutCommit(context, this._args.oplayoutcommit);
        res.locr_resok4.locr_newsize.ns_sizechanged = newSize.isPresent();
        if (newSize.isPresent()) {
            res.locr_resok4.locr_newsize.ns_size = new length4(newSize.getAsLong());
        }
        res.locr_status = 0;
    }
}

