/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import java.util.Arrays;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.FsExport;
import org.dcache.nfs.status.AccessException;
import org.dcache.nfs.status.BadIoModeException;
import org.dcache.nfs.status.InvalException;
import org.dcache.nfs.status.LayoutUnavailableException;
import org.dcache.nfs.status.NfsIoException;
import org.dcache.nfs.status.NotSuppException;
import org.dcache.nfs.status.OpenModeException;
import org.dcache.nfs.status.TooSmallException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.Layout;
import org.dcache.nfs.v4.NFS4State;
import org.dcache.nfs.v4.NFSv41DeviceManager;
import org.dcache.nfs.v4.Stateids;
import org.dcache.nfs.v4.xdr.LAYOUTGET4res;
import org.dcache.nfs.v4.xdr.LAYOUTGET4resok;
import org.dcache.nfs.v4.xdr.layout4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.nfs.vfs.Inode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationLAYOUTGET
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationLAYOUTGET.class);

    public OperationLAYOUTGET(nfs_argop4 args) {
        super(args, 50);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws IOException {
        Layout ioLayout;
        LAYOUTGET4res res = result.oplayoutget;
        NFSv41DeviceManager pnfsDeviceManager = context.getDeviceManager().orElseThrow(() -> new NotSuppException("pNFS device manager not configured"));
        if (this._args.oplayoutget.loga_length.value != -1L && this._args.oplayoutget.loga_length.value < this._args.oplayoutget.loga_minlength.value) {
            throw new InvalException("requested layout length is smaller than minlen");
        }
        if (this._args.oplayoutget.loga_length.value != -1L) {
            this._args.oplayoutget.loga_offset.checkOverflow(this._args.oplayoutget.loga_length, "offset + length overflow");
        }
        if (this._args.oplayoutget.loga_minlength.value != -1L) {
            this._args.oplayoutget.loga_offset.checkOverflow(this._args.oplayoutget.loga_minlength, "offset + minlength overflow");
        }
        if (this._args.oplayoutget.loga_iomode != 2 && this._args.oplayoutget.loga_iomode != 1) {
            throw new BadIoModeException("invalid loga_iomode");
        }
        Inode inode = context.currentInode();
        if (!this.isPnfsAllowed(context, inode)) {
            throw new LayoutUnavailableException("pNFS is not allowed");
        }
        int ioMode = this._args.oplayoutget.loga_iomode;
        stateid4 stateid = Stateids.getCurrentStateidIfNeeded(context, this._args.oplayoutget.loga_stateid);
        NFS4State state = context.getSession().getClient().state(stateid);
        int shareAccess = context.getStateHandler().getFileTracker().getShareAccess(context.getSession().getClient(), inode, state.getOpenState().stateid());
        if ((shareAccess & 2) == 0 && (ioMode & 2) != 0) {
            throw new OpenModeException("can't provide RW layout for RO open");
        }
        try {
            ioLayout = pnfsDeviceManager.layoutGet(context, this._args.oplayoutget);
        }
        catch (NfsIoException e) {
            throw new LayoutUnavailableException("IO error on layout get", (Throwable)e);
        }
        layout4[] layoutSegments = ioLayout.getLayoutSegments();
        int n = 0;
        int layoutBodySize = 0;
        for (layout4 layout : layoutSegments) {
            if ((layoutBodySize += layout.lo_content.loc_body.length) > this._args.oplayoutget.loga_maxcount.value) break;
            ++n;
        }
        if (n == 0) {
            throw new TooSmallException("layout body size is bigger than client can accept");
        }
        layoutSegments = n == layoutSegments.length ? layoutSegments : Arrays.copyOf(layoutSegments, n);
        res.logr_resok4 = new LAYOUTGET4resok();
        res.logr_resok4.logr_layout = layoutSegments;
        res.logr_resok4.logr_stateid = ioLayout.getStateid();
        res.logr_resok4.logr_return_on_close = ioLayout.returnOnClose();
        res.logr_status = 0;
    }

    private boolean isPnfsAllowed(CompoundContext context, Inode inode) throws ChimeraNFSException {
        FsExport export = context.getExportTable().getExport(inode.exportIndex(), context.getRemoteSocketAddress().getAddress());
        if (export == null) {
            throw new AccessException("no export");
        }
        return export.isWithPnfs();
    }
}

