/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.InvalException;
import org.dcache.nfs.status.LockRangeException;
import org.dcache.nfs.status.ServerFaultException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NFS4Client;
import org.dcache.nfs.v4.NFS4State;
import org.dcache.nfs.v4.StateOwner;
import org.dcache.nfs.v4.Stateids;
import org.dcache.nfs.v4.nlm.LockException;
import org.dcache.nfs.v4.nlm.LockRangeUnavailabeException;
import org.dcache.nfs.v4.nlm.NlmLock;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.nfs.vfs.Inode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationLOCKU
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationLOCKU.class);

    public OperationLOCKU(nfs_argop4 args) {
        super(args, 14);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException {
        Inode inode = context.currentInode();
        stateid4 lockStateid = Stateids.getCurrentStateidIfNeeded(context, this._args.oplocku.lock_stateid);
        if (this._args.oplocku.length.value == 0L) {
            throw new InvalException("zero lock len");
        }
        this._args.oplocku.offset.checkOverflow(this._args.oplocku.length, "offset + len overflow");
        try {
            NFS4Client client = context.getMinorversion() == 0 ? context.getStateHandler().getClientIdByStateId(lockStateid) : context.getSession().getClient();
            NFS4State lock_state = client.state(lockStateid);
            StateOwner lockOwner = lock_state.getStateOwner();
            if (context.getMinorversion() == 0) {
                lockOwner.acceptAsNextSequence(this._args.oplocku.seqid);
            }
            NlmLock lock = new NlmLock(lockOwner, this._args.oplocku.locktype, this._args.oplocku.offset.value, this._args.oplocku.length.value);
            try {
                context.getLm().unlock(inode.getFileId(), lock);
            }
            catch (LockRangeUnavailabeException lockRangeUnavailabeException) {
                // empty catch block
            }
            lock_state.bumpSeqid();
            context.currentStateid(lock_state.stateid());
            result.oplocku.status = 0;
            result.oplocku.lock_stateid = lock_state.stateid();
        }
        catch (LockRangeUnavailabeException e) {
            throw new LockRangeException();
        }
        catch (LockException e) {
            throw new ServerFaultException("lock error", (Throwable)e);
        }
    }
}

