/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.NotDirException;
import org.dcache.nfs.status.SymlinkException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NameFilter;
import org.dcache.nfs.v4.Stateids;
import org.dcache.nfs.v4.xdr.LOOKUP4res;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationLOOKUP
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationLOOKUP.class);

    public OperationLOOKUP(nfs_argop4 args) {
        super(args, 15);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException {
        LOOKUP4res res = result.oplookup;
        String name2 = NameFilter.convertName(this._args.oplookup.objname.value);
        Stat stat = context.getFs().getattr(context.currentInode());
        if (stat.type() == Stat.Type.SYMLINK) {
            throw new SymlinkException("parent not a symbolic link");
        }
        if (stat.type() != Stat.Type.DIRECTORY) {
            throw new NotDirException("parent not a directory");
        }
        Inode newInode = context.getFs().lookup(context.currentInode(), name2);
        context.currentInode(newInode);
        context.currentStateid(Stateids.ZeroStateId());
        res.status = 0;
    }
}

