/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import java.util.Optional;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.AccessException;
import org.dcache.nfs.status.BadXdrException;
import org.dcache.nfs.status.ExistException;
import org.dcache.nfs.status.GraceException;
import org.dcache.nfs.status.InvalException;
import org.dcache.nfs.status.IsDirException;
import org.dcache.nfs.status.NotDirException;
import org.dcache.nfs.status.SymlinkException;
import org.dcache.nfs.status.WrongTypeException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.AttributeMap;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NFS4Client;
import org.dcache.nfs.v4.NameFilter;
import org.dcache.nfs.v4.StateOwner;
import org.dcache.nfs.v4.xdr.OPEN4res;
import org.dcache.nfs.v4.xdr.OPEN4resok;
import org.dcache.nfs.v4.xdr.bitmap4;
import org.dcache.nfs.v4.xdr.change_info4;
import org.dcache.nfs.v4.xdr.changeid4;
import org.dcache.nfs.v4.xdr.fattr4_size;
import org.dcache.nfs.v4.xdr.mode4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.open_delegation4;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.nfs.v4.xdr.uint32_t;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.oncrpc4j.rpc.OncRpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationOPEN
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationOPEN.class);

    public OperationOPEN(nfs_argop4 args) {
        super(args, 18);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException, OncRpcException {
        NFS4Client client;
        OPEN4res res = result.opopen;
        if (context.getMinorversion() > 0) {
            client = context.getSession().getClient();
        } else {
            client = context.getStateHandler().getConfirmedClient(this._args.opopen.owner.clientid);
            client.updateLeaseTime();
            _log.debug("open request form {}", (Object)this._args.opopen.owner);
        }
        StateOwner owner = client.getOrCreateOwner(this._args.opopen.owner.owner, this._args.opopen.seqid);
        res.resok4 = new OPEN4resok();
        res.resok4.attrset = new bitmap4();
        res.resok4.delegation = new open_delegation4();
        res.resok4.delegation.delegation_type = 0;
        res.resok4.cinfo = new change_info4();
        res.resok4.cinfo.atomic = true;
        switch (this._args.opopen.claim.claim) {
            case 0: {
                Inode inode;
                if (client.needReclaim() || context.getStateHandler().isGracePeriod()) {
                    throw new GraceException();
                }
                Inode parent = context.currentInode();
                Stat stat = context.getFs().getattr(parent);
                if (stat.type() != Stat.Type.DIRECTORY) {
                    throw new NotDirException();
                }
                res.resok4.cinfo.before = new changeid4(stat.getGeneration());
                String name2 = NameFilter.convertName(this._args.opopen.claim.file.value);
                _log.debug("regular open for : {}", (Object)name2);
                if (this._args.opopen.openhow.opentype == 1) {
                    boolean exclusive = this._args.opopen.openhow.how.mode == 2 || this._args.opopen.openhow.how.mode == 3;
                    AttributeMap attributeMap = switch (this._args.opopen.openhow.how.mode) {
                        case 0, 1 -> new AttributeMap(this._args.opopen.openhow.how.createattrs);
                        case 2 -> new AttributeMap(null);
                        case 3 -> new AttributeMap(this._args.opopen.openhow.how.ch_createboth.cva_attrs);
                        default -> throw new BadXdrException("bad value: " + this._args.opopen.openhow.how.mode);
                    };
                    try {
                        int mode = 384;
                        Optional createMode = attributeMap.get(33);
                        Optional createSize = attributeMap.get(4);
                        if (createMode.isPresent()) {
                            mode = ((mode4)createMode.get()).value;
                        }
                        _log.debug("Creating a new file: {}", (Object)name2);
                        inode = context.getFs().create(context.currentInode(), Stat.Type.REGULAR, name2, context.getSubject(), mode);
                        if (createMode.isPresent()) {
                            res.resok4.attrset.set(33);
                        }
                        if (createSize.isPresent() && ((fattr4_size)createSize.get()).value == 0L) {
                            res.resok4.attrset.set(4);
                        }
                        res.resok4.cinfo.after = new changeid4(context.getFs().getattr(parent).getGeneration());
                    }
                    catch (ExistException e) {
                        if (exclusive) {
                            throw new ExistException();
                        }
                        res.resok4.cinfo.after = new changeid4(stat.getGeneration());
                        inode = context.getFs().lookup(context.currentInode(), name2);
                        if (_log.isDebugEnabled()) {
                            Stat fileStat = context.getFs().getattr(context.currentInode());
                            _log.debug("Opening existing file: {}, uid: {}, gid: {}, mode: 0{}", name2, fileStat.getUid(), fileStat.getGid(), Integer.toOctalString(fileStat.getMode() & 0x1FF));
                        }
                        if (context.getFs().access(context.getSubject(), inode, 4) == 0) {
                            throw new AccessException();
                        }
                        Optional createSize = attributeMap.get(4);
                        if (createSize.isPresent() && ((fattr4_size)createSize.get()).value == 0L) {
                            Stat stat4size = new Stat();
                            stat4size.setSize(0L);
                            context.getFs().setattr(inode, stat4size);
                            res.resok4.attrset.set(4);
                        }
                    }
                } else {
                    res.resok4.cinfo.after = new changeid4(stat.getGeneration());
                    inode = context.getFs().lookup(context.currentInode(), name2);
                    this.checkCanAccess(context, inode, this._args.opopen.share_access);
                }
                context.currentInode(inode);
                break;
            }
            case 1: {
                client.wantReclaim();
            }
            case 4: {
                _log.debug("open by Inode for : {}", (Object)context.currentInode());
                res.resok4.cinfo.before = new changeid4(0L);
                res.resok4.cinfo.after = new changeid4(0L);
                Inode inode = context.currentInode();
                this.checkCanAccess(context, inode, this._args.opopen.share_access);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                _log.warn("Unimplemented open claim: {}", (Object)this._args.opopen.claim.claim);
                throw new InvalException("Unimplemented open claim: {}" + this._args.opopen.claim.claim);
            }
            default: {
                _log.warn("BAD open claim: {}", (Object)this._args.opopen.claim.claim);
                throw new InvalException("BAD open claim: {}" + this._args.opopen.claim.claim);
            }
        }
        res.resok4.rflags = context.getMinorversion() > 0 ? new uint32_t(4) : new uint32_t(6);
        stateid4 stateid = context.getStateHandler().getFileTracker().addOpen(client, owner, context.currentInode(), this._args.opopen.share_access.value, this._args.opopen.share_deny.value);
        context.currentStateid(stateid);
        res.resok4.stateid = stateid;
        res.status = 0;
    }

    private void checkCanAccess(CompoundContext context, Inode inode, uint32_t share_access) throws IOException {
        int accessMode = switch (share_access.value & 0xFFFF00FF) {
            case 1 -> 1;
            case 2 -> 4;
            case 3 -> 5;
            default -> throw new InvalException("Invalid share_access mode: " + share_access.value);
        };
        if (context.getFs().access(context.getSubject(), inode, accessMode) != accessMode) {
            throw new AccessException();
        }
        Stat stat = context.getFs().getattr(inode);
        switch (stat.type()) {
            case REGULAR: {
                break;
            }
            case DIRECTORY: {
                throw new IsDirException();
            }
            case SYMLINK: {
                throw new SymlinkException();
            }
            default: {
                throw context.getMinorversion() == 0 ? new SymlinkException() : new WrongTypeException();
            }
        }
    }
}

