/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.xdr.change_info4;
import org.dcache.nfs.v4.xdr.changeid4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.oncrpc4j.rpc.OncRpcException;

public class OperationREMOVEXATTR
extends AbstractNFSv4Operation {
    public OperationREMOVEXATTR(nfs_argop4 args) {
        super(args, 75);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException, OncRpcException {
        Inode inode = context.currentInode();
        result.opremovexattr.rxr_info = new change_info4();
        result.opremovexattr.rxr_info.atomic = true;
        Stat stat = context.getFs().getattr(inode);
        result.opremovexattr.rxr_info.before = new changeid4(stat.getGeneration());
        context.getFs().removeXattr(inode, this._args.opremovexattr.rxa_name);
        stat = context.getFs().getattr(inode);
        result.opremovexattr.rxr_info.after = new changeid4(stat.getGeneration());
        result.setStatus(0);
    }
}

