/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.NotDirException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NameFilter;
import org.dcache.nfs.v4.xdr.RENAME4res;
import org.dcache.nfs.v4.xdr.RENAME4resok;
import org.dcache.nfs.v4.xdr.change_info4;
import org.dcache.nfs.v4.xdr.changeid4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationRENAME
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationRENAME.class);

    public OperationRENAME(nfs_argop4 args) {
        super(args, 29);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException {
        RENAME4res res = result.oprename;
        res.resok4 = new RENAME4resok();
        res.status = 0;
        res.resok4.source_cinfo = new change_info4();
        res.resok4.source_cinfo.atomic = true;
        res.resok4.target_cinfo = new change_info4();
        res.resok4.target_cinfo.atomic = true;
        Inode sourceDir = context.savedInode();
        Inode destDir = context.currentInode();
        Stat sourceStat = context.getFs().getattr(sourceDir);
        Stat destStat = context.getFs().getattr(destDir);
        if (sourceStat.type() != Stat.Type.DIRECTORY) {
            throw new NotDirException("source path not a directory");
        }
        if (destStat.type() != Stat.Type.DIRECTORY) {
            throw new NotDirException("destination path  not a directory");
        }
        String oldName = NameFilter.convertName(this._args.oprename.oldname.value);
        String newName = NameFilter.convertName(this._args.oprename.newname.value);
        _log.debug("Rename: src={} name={} dest={} name={}", sourceDir, oldName, destDir, newName);
        res.resok4.source_cinfo.before = new changeid4(sourceStat.getGeneration());
        res.resok4.target_cinfo.before = new changeid4(destStat.getGeneration());
        boolean isChanged = context.getFs().move(sourceDir, oldName, destDir, newName);
        if (isChanged) {
            res.resok4.source_cinfo.after = new changeid4(context.getFs().getattr(sourceDir).getGeneration());
            res.resok4.target_cinfo.after = new changeid4(context.getFs().getattr(destDir).getGeneration());
        } else {
            res.resok4.source_cinfo.after = res.resok4.source_cinfo.before;
            res.resok4.target_cinfo.after = res.resok4.target_cinfo.before;
        }
    }
}

