/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.InvalException;
import org.dcache.nfs.status.IsDirException;
import org.dcache.nfs.status.NfsIoException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.xdr.WRITE4res;
import org.dcache.nfs.v4.xdr.WRITE4resok;
import org.dcache.nfs.v4.xdr.count4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.vfs.Stat;
import org.dcache.nfs.vfs.VirtualFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationWRITE
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationWRITE.class);

    public OperationWRITE(nfs_argop4 args) {
        super(args, 38);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException {
        WRITE4res res = result.opwrite;
        this._args.opwrite.offset.checkOverflow(this._args.opwrite.data.remaining(), "offset + length overflow");
        Stat stat = context.getFs().getattr(context.currentInode());
        if (stat.type() == Stat.Type.DIRECTORY) {
            throw new IsDirException();
        }
        if (stat.type() == Stat.Type.SYMLINK) {
            throw new InvalException("path is a symlink");
        }
        if (context.getMinorversion() == 0) {
            context.getStateHandler().updateClientLeaseTime(this._args.opwrite.stateid);
        }
        long offset = this._args.opwrite.offset.value;
        VirtualFileSystem.WriteResult writeResult = context.getFs().write(context.currentInode(), this._args.opwrite.data, offset, VirtualFileSystem.StabilityLevel.fromStableHow(this._args.opwrite.stable));
        if (writeResult.getBytesWritten() < 0) {
            throw new NfsIoException("IO not allowed");
        }
        res.status = 0;
        res.resok4 = new WRITE4resok();
        res.resok4.count = new count4(writeResult.getBytesWritten());
        res.resok4.committed = writeResult.getStabilityLevel().toStableHow();
        res.resok4.writeverf = context.getRebootVerifier();
    }
}

