/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4.ds;

import java.io.IOException;
import java.nio.channels.FileChannel;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.InvalException;
import org.dcache.nfs.status.IsDirException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.xdr.COMMIT4res;
import org.dcache.nfs.v4.xdr.COMMIT4resok;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.vfs.FsCache;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.oncrpc4j.rpc.OncRpcException;

public class DSOperationCOMMIT
extends AbstractNFSv4Operation {
    private final FsCache _fsCache;

    public DSOperationCOMMIT(nfs_argop4 args, FsCache fsCache) {
        super(args, 5);
        this._fsCache = fsCache;
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException, OncRpcException {
        this._args.opcommit.offset.checkOverflow(this._args.opcommit.count.value, "offset + length overflow");
        COMMIT4res res = result.opcommit;
        if (context.getFs() != null) {
            Inode inode = context.currentInode();
            Stat stat = context.getFs().getattr(inode);
            if (stat.type() == Stat.Type.DIRECTORY) {
                throw new IsDirException("Invalid can't commit a directory");
            }
            if (stat.type() != Stat.Type.REGULAR) {
                throw new InvalException("Invalid object type");
            }
            FileChannel out = this._fsCache.get(inode);
            Stat newStat = new Stat();
            newStat.setSize(out.size());
            context.getFs().setattr(context.currentInode(), newStat);
        }
        res.status = 0;
        res.resok4 = new COMMIT4resok();
        res.resok4.writeverf = context.getRebootVerifier();
    }
}

