/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4.ds;

import java.io.IOException;
import java.nio.channels.FileChannel;
import org.dcache.nfs.status.InvalException;
import org.dcache.nfs.status.IsDirException;
import org.dcache.nfs.status.NfsIoException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.Stateids;
import org.dcache.nfs.v4.xdr.WRITE4res;
import org.dcache.nfs.v4.xdr.WRITE4resok;
import org.dcache.nfs.v4.xdr.count4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.vfs.FsCache;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSOperationWRITE
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(DSOperationWRITE.class);
    private final FsCache _fsCache;

    public DSOperationWRITE(nfs_argop4 args, FsCache fsCache) {
        super(args, 38);
        this._fsCache = fsCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws IOException {
        WRITE4res res = result.opwrite;
        long offset = this._args.opwrite.offset.value;
        this._args.opwrite.offset.checkOverflow(this._args.opwrite.data.remaining(), "offset + length overflow");
        Inode inode = context.currentInode();
        Stat stat = context.getFs().getattr(inode);
        if (stat.type() == Stat.Type.DIRECTORY) {
            throw new IsDirException("Can't WRITE into a directory inode");
        }
        if (stat.type() != Stat.Type.REGULAR) {
            throw new InvalException("Invalid object type");
        }
        if (context.getMinorversion() == 0 && !Stateids.ZeroStateId().equalsWithSeq(this._args.opwrite.stateid) && !Stateids.OneStateId().equalsWithSeq(this._args.opwrite.stateid)) {
            context.getStateHandler().updateClientLeaseTime(this._args.opwrite.stateid);
        }
        FileChannel out = this._fsCache.get(inode);
        long lastSize = out.size();
        this._args.opwrite.data.rewind();
        int bytesWritten = out.write(this._args.opwrite.data, offset);
        if (bytesWritten < 0) {
            throw new NfsIoException("IO not allowed");
        }
        res.status = 0;
        res.resok4 = new WRITE4resok();
        res.resok4.count = new count4(bytesWritten);
        res.resok4.committed = this._args.opwrite.stable;
        res.resok4.writeverf = context.getRebootVerifier();
        FileChannel fileChannel = out;
        synchronized (fileChannel) {
            if (this._args.opwrite.stable != 0 && offset + (long)bytesWritten > lastSize) {
                Stat newStat = new Stat();
                newStat.setSize(out.size());
                context.getFs().setattr(context.currentInode(), newStat);
            }
        }
        _log.debug("MOVER: {}@{} written, {} requested. New File size {}", bytesWritten, offset, this._args.opwrite.data, out.size());
    }
}

