/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4.nlm;

import com.google.common.util.concurrent.Striped;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import org.dcache.nfs.v4.nlm.AbstractLockManager;
import org.dcache.nfs.v4.nlm.NlmLock;

public class SimpleLm
extends AbstractLockManager {
    private final Striped<Lock> objLock;
    private final ConcurrentHashMap<String, List<NlmLock>> locks = new ConcurrentHashMap();

    public SimpleLm() {
        this(Runtime.getRuntime().availableProcessors() * 4);
    }

    public SimpleLm(int concurrency) {
        this.objLock = Striped.lock(concurrency);
    }

    @Override
    protected Lock getObjectLock(byte[] objId) {
        String key = this.toKey(objId);
        return this.objLock.get(key);
    }

    @Override
    protected Collection<NlmLock> getActiveLocks(byte[] objId) {
        String key = this.toKey(objId);
        return this.locks.getOrDefault(key, Collections.emptyList());
    }

    @Override
    protected void add(byte[] objId, NlmLock lock) {
        String key = this.toKey(objId);
        Collection l = this.locks.computeIfAbsent(key, k -> new ArrayList());
        l.add(lock);
    }

    @Override
    protected boolean remove(byte[] objId, NlmLock lock) {
        String key = this.toKey(objId);
        Collection l = (Collection)this.locks.get(key);
        boolean isRemoved = false;
        if (l != null) {
            isRemoved = l.remove(lock);
            if (l.isEmpty()) {
                this.locks.remove(key);
            }
        }
        return isRemoved;
    }

    @Override
    protected void addAll(byte[] objId, Collection<NlmLock> locks) {
        String key = this.toKey(objId);
        Collection l = this.locks.computeIfAbsent(key, k -> new ArrayList());
        l.addAll(locks);
    }

    @Override
    protected void removeAll(byte[] objId, Collection<NlmLock> locks) {
        String key = this.toKey(objId);
        Collection l = (Collection)this.locks.get(key);
        if (l != null) {
            l.removeAll(locks);
            if (l.isEmpty()) {
                this.locks.remove(key);
            }
        }
    }

    private final String toKey(byte[] objId) {
        return Base64.getEncoder().encodeToString(objId);
    }
}

